#include <config.h>

#include <dcopclient.h>
#include <dcopref.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <kurl.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include <tqdir.h>

#include <stdlib.h>

#include "kviewshell.h"


static TDECmdLineOptions options[] =
{
  { "unique", I18N_NOOP("Check if the file is loaded in another KFaxView instance.\nIf it is, bring up the other KFaxView. Otherwise, load the file."), 0 },
  { "g", 0, 0 },
  { "goto <pagenumber>", I18N_NOOP("Navigate to this page"), 0 },
  // The rest of the options are only for compability with the old KFax
  { "f", 0, 0 },
  { "fine",         I18N_NOOP("(obsolete)"), 0 },
  { "n", 0, 0 },
  { "normal",       I18N_NOOP("(obsolete)"), 0 },
  { "height",       I18N_NOOP("(obsolete)"), 0 },
  { "w", 0, 0 },
  { "width",        I18N_NOOP("(obsolete)"), 0 },
  { "l", 0, 0 },
  { "landscape",    I18N_NOOP("(obsolete)"), 0 },
  { "u", 0, 0 },
  { "upsidedown",   I18N_NOOP("(obsolete)"), 0 },
  { "i", 0, 0 },
  { "invert",       I18N_NOOP("(obsolete)"), 0 },
  { "m", 0, 0 },
  { "mem <bytes>",  I18N_NOOP("(obsolete)"), 0 },
  { "r", 0, 0 },
  { "reverse",      I18N_NOOP("(obsolete)"), 0 },
  { "2" ,           I18N_NOOP("(obsolete)"), 0 },
  { "4",            I18N_NOOP("(obsolete)"), 0 },
  { "+file(s)", I18N_NOOP("Files to load"), 0 },
  TDECmdLineLastOption
};


static const char description[] = I18N_NOOP("A previewer for Fax files.");


int main(int argc, char** argv)
{
  TDEAboutData about ("kfaxview", I18N_NOOP("KFaxView"), "3.5",
                    description, TDEAboutData::License_GPL,
                    "Stephan Kebekus, Helge Deller",
                    I18N_NOOP("Fax-G3 plugin for the KViewShell document viewer framework."));

  about.addAuthor ("Stefan Kebekus",
                   I18N_NOOP("KViewShell plugin"),
                   "kebekus@kde.org",
                   "http://www.mi.uni-koeln.de/~kebekus");

  about.addAuthor ("Wilfried Huss",
                   I18N_NOOP("KViewShell maintainer"),
                   "Wilfried.Huss@gmx.at");

  about.addAuthor ("Helge Deller",
                   I18N_NOOP("Fax file loading"),
                   "deller@gmx.de");

  TDECmdLineArgs::init(argc, argv, &about);
  TDECmdLineArgs::addCmdLineOptions(options);
  TDEApplication app;

  // see if we are starting with session management
  if (app.isRestored())
  {
    RESTORE(KViewShell);
  }
  else
  {
    TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();

    if (args->isSet("unique"))
    {
      // With --unique, we need 2 arguments.
      if (args->count() < 1) 
      {
        args->usage();
        exit(-1);
      }

      // Find the fully qualified file name of the file we are
      // loading. Complain, if we are given a URL which does not point
      // to a local file.
      KURL url(args->url(0));

      if (!url.isValid()) 
      {
        kdError(4300) << TQString(I18N_NOOP("The URL %1 is not well-formed.")).arg(args->arg(0)) << endl;
        return -1;
      }

      if (!url.isLocalFile()) 
      {
        kdError(4300) << TQString(I18N_NOOP("The URL %1 does not point to a local file. You can only specify local "
             "files if you are using the '--unique' option.")).arg(args->arg(0)) << endl;
        return -1;
      }

      TQString qualPath = TQFileInfo(url.path()).absFilePath();

      app.dcopClient()->attach();
      // We need to register as "kviewshell" to stay compatible with existing DCOP-skripts.
      TQCString id = app.dcopClient()->registerAs("unique-kviewshell");
      if (id.isNull())
        kdError(4300) << "There was an error using dcopClient()->registerAs()." << endl;
      QCStringList apps = app.dcopClient()->registeredApplications();
      for ( QCStringList::Iterator it = apps.begin(); it != apps.end(); ++it ) 
      {
        if ((*it).find("kviewshell") == 0) 
        {
          TQByteArray data, replyData;
          TQCString replyType;
          TQDataStream arg(data, IO_WriteOnly);
          bool result;
          arg << qualPath.stripWhiteSpace();
          if (!app.dcopClient()->call( *it, "tdemultipage", "is_file_loaded(TQString)", data, replyType, replyData))
            kdError(4300) << "There was an error using DCOP." << endl;
          else 
          {
            TQDataStream reply(replyData, IO_ReadOnly);
            if (replyType == "bool") 
            {
              reply >> result;
              if (result == true) 
              {
                if (app.dcopClient()->send( *it, "tdemultipage", "jumpToReference(TQString)", url.ref()) == true)
                {
                  app.dcopClient()->detach();
                  return 0;
                }
              }
            }
            else
              kdError(4300) << "The DCOP function 'doIt' returned an unexpected type of reply!";
          }
        }
      }
    }

    // We need to register as "kviewshell" to stay compatible with existing DCOP-skripts.
    app.dcopClient()->registerAs("kviewshell");
    KViewShell* shell = new KViewShell("image/fax-g3");
    shell->show();
    app.processEvents();

    if (args->count() > 0)
    {
      KURL url = args->url(0);
      if (!url.hasRef() && args->isSet("goto"))
      {
        // If the url doesn't already has a reference part, add the
        // argument of --goto to the url as reference, to make the
        // KViewShell jump to this page.
        TQString reference = args->getOption("goto");
        url.setHTMLRef(reference);
      }
      shell->openURL(url);
    }
  }

  return app.exec();
}
