/***************************************************************************
                              kchatwidget.h
                             ---------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCHATWIDGET_H
#define KCHATWIDGET_H

#include <tqpushbutton.h>
#include <tqmultilineedit.h>
#include <tqlineedit.h>
#include "dialogs/chatDlg.h"
#include "kmessage.h"

class KChatWidget : public chatDlg
{
	TQ_OBJECT
  
public:
	KChatWidget(TQWidget *parent = 0, const char *name = 0);

	void clear();
	void setNickname(const TQString &nickname) { m_currentNickname = nickname; }

public slots:
	void slotAcceptMsg(bool value);
	void slotComputeMessage();
	void slotReceivedMessage(const TQString &nickname, const TQString &msg, bool fromenemy = true);

signals:
	void sigSendMessage(const TQString &);
	void sigChangeEnemyNickname(const TQString &);
	void sigChangeOwnNickname(const TQString &);

private:
	virtual bool eventFilter(TQObject *, TQEvent *);

	TQString m_currentNickname;
	bool m_acceptMsgs;
};

#endif
