/*
    This file is part of the TDE games library
    Copyright (C) 2001-02 Nicolas Hadacek (hadacek@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KEXTHIGHSCORE_GUI_H
#define KEXTHIGHSCORE_GUI_H

#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqvbox.h>
#include <tqtabwidget.h>

#include <tdelistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kdialogbase.h>

#include "kexthighscore.h"


namespace KExtHighscore
{

class ItemContainer;
class ItemArray;
class Score;
class AdditionalTab;

//-----------------------------------------------------------------------------
class ShowItem : public TDEListViewItem
{
 public:
    ShowItem(TQListView *, bool highlight);

 protected:
    virtual void paintCell(TQPainter *, const TQColorGroup &, int column,
						   int width, int align);

 private:
    bool _highlight;
};

class ScoresList : public TDEListView
{
 TQ_OBJECT
  
 public:
    ScoresList(TQWidget *parent);

    void addHeader(const ItemArray &);

 protected:
    TQListViewItem *addLine(const ItemArray &, uint index, bool highlight);
    virtual TQString itemText(const ItemContainer &, uint row) const = 0;

 private:
    virtual void addLineItem(const ItemArray &, uint index,
                             TQListViewItem *item);
};

//-----------------------------------------------------------------------------
class HighscoresList : public ScoresList
{
 TQ_OBJECT
  
 public:
    HighscoresList(TQWidget *parent);

    void load(const ItemArray &, int highlight);

 protected:
    TQString itemText(const ItemContainer &, uint row) const;
};

class HighscoresWidget : public TQWidget
{
 TQ_OBJECT
  
 public:
    HighscoresWidget(TQWidget *parent);

    void load(int rank);

 signals:
    void tabChanged(int i);

 public slots:
    void changeTab(int i);

 private slots:
    void showURL(const TQString &) const;
    void tabChanged() { emit tabChanged(_tw->currentPageIndex()); }

 private:
    TQTabWidget     *_tw;
    HighscoresList *_scoresList, *_playersList;
    KURLLabel      *_scoresUrl, *_playersUrl;
    AdditionalTab  *_statsTab, *_histoTab;
};

class HighscoresDialog : public KDialogBase
{
 TQ_OBJECT
  
 public:
    HighscoresDialog(int rank, TQWidget *parent);

 private slots:
    void slotUser1();
    void slotUser2();
    void tabChanged(int i) { _tab = i; }
    void createPage(TQWidget *);

 private:
    int _rank, _tab;
    TQWidget *_current;
    TQValueVector<HighscoresWidget *> _widgets;
};

//-----------------------------------------------------------------------------
class LastMultipleScoresList : public ScoresList
{
    TQ_OBJECT
  
public:
    LastMultipleScoresList(const TQValueVector<Score> &, TQWidget *parent);

private:
    void addLineItem(const ItemArray &, uint index, TQListViewItem *line);
    TQString itemText(const ItemContainer &, uint row) const;

private:
    const TQValueVector<Score> &_scores;
};

class TotalMultipleScoresList : public ScoresList
{
    TQ_OBJECT
  
public:
    TotalMultipleScoresList(const TQValueVector<Score> &, TQWidget *parent);

private:
    void addLineItem(const ItemArray &, uint index, TQListViewItem *line);
    TQString itemText(const ItemContainer &, uint row) const;

private:
    const TQValueVector<Score> &_scores;
};

//-----------------------------------------------------------------------------
class ConfigDialog : public KDialogBase
{
 TQ_OBJECT
  
 public:
    ConfigDialog(TQWidget *parent);

    bool hasBeenSaved() const { return _saved; }

 private slots:
    void modifiedSlot();
    void removeSlot();
    void accept();
    void slotApply() { save(); }
    void nickNameChanged(const TQString &);

 private:
    bool         _saved;
    TQCheckBox   *_WWHEnabled;
    TQLineEdit   *_nickname, *_comment;
    KLineEdit   *_key, *_registeredName;
    KPushButton *_removeButton;

    void load();
    bool save();
};

//-----------------------------------------------------------------------------
class AskNameDialog : public KDialogBase
{
 TQ_OBJECT
  
 public:
    AskNameDialog(TQWidget *parent);

    TQString name() const { return _edit->text(); }
    bool dontAskAgain() const { return _checkbox->isChecked(); }

 private slots:
    void nameChanged();

 private:
    TQLineEdit *_edit;
    TQCheckBox *_checkbox;
};

} // namespace

#endif
