#ifndef _PLANET_INFO_H_
#define _PLANET_INFO_H_

#include <tqframe.h>
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqpalette.h>

#include "gamecore.h"

class TQLabel;

struct planet_info_buffer {
    Planet *planet;
    int production;
    int ships;
    float killRate;
};

typedef TQPtrList<planet_info_buffer> PlanetInfoList;
typedef TQPtrListIterator<planet_info_buffer> PlanetInfoListIterator;

class PlanetInfo : public TQFrame
{
    TQ_OBJECT
  
        
public:
    PlanetInfo( TQWidget *parent, TQPalette palette );
    virtual ~PlanetInfo();

    void setPlanetList( PlanetList &newPlanets );
    void rescanPlanets();
    TQSize sizeHint() const;
    
public slots:
    void showPlanet( Planet * );

private:
    void emptyPlanetInfoList();
    void clearDisplay();
    
    PlanetList *planets;
    PlanetInfoList planet_stats;

    TQLabel *name;
    TQLabel *owner;
    TQLabel *ships;
    TQLabel *production;
    TQLabel *kill_percent;
};

#endif  // _PLANET_INFO_H_

