/***************************************************************************

                   lesson properties dialog page

    -----------------------------------------------------------------------

    begin          : Thu Jun 3 22:03:50 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef LessOptPage_included
#define LessOptPage_included

#include "LessOptPageForm.h"

#include <vector>
using namespace std;

class kvoctrainDoc;
class TQComboBox;

class LessOptPage : public LessOptPageForm
{
    TQ_OBJECT
  

public:

  LessOptPage
  (
    TQComboBox     *lessons,
    kvoctrainDoc  *doc,
    TQWidget       *parent = NULL,
    const char    *name = NULL
  );

  void getLesson (TQComboBox *ret_lesson, vector<int>& ret_Index);

  static void cleanUnused(kvoctrainDoc *doc,
                          const TQComboBox *lessons,
                          const vector<int> &lessonIndex,
                          int old_lessons,
                          vector<int> &lessons_in_use);

protected:
  void updateListBox(int start);

protected slots:

  void slotDeleteLesson();
  void slotNewLesson();
  void slotLessonChosen(int);
  void slotModifyLesson();
  void slotCleanup();

private:
  kvoctrainDoc  *doc;
  int            act_lesson;
  vector<int>    lessonIndex; // contains indices of lesson on exec()
                              // negative values are new lessons
};
#endif // LessOptPage_included
