 /***************************************************************************

              dialog page for characters from the phonetic alphabet

    -----------------------------------------------------------------------

    begin          : Sun Dec 9 2001

    copyright      : (C) 2001-2002 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001-2002 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PHONETICENTRYPAGE_H
#define PHONETICENTRYPAGE_H

#include <tqpushbutton.h>

#include <kdialogbase.h>

class PhoneticEntryPage : public KDialogBase
{
  TQ_OBJECT
  

public:
  PhoneticEntryPage(const TQFont &ipafont, TQWidget *parent = 0, const char *name = 0, bool modal = false);

signals:
  void charSelected(wchar_t);

protected:
  void keyPressEvent( TQKeyEvent *e );

  friend class PhoneticButton;
};


class PhoneticButton : public TQPushButton
{
  TQ_OBJECT
  

public:
  PhoneticButton (const TQString & text, TQWidget * parent, PhoneticEntryPage *_page, const char * name = 0)
  : TQPushButton (text, parent, name), page(_page) {}

protected slots:
  void slotClicked();

protected:
  PhoneticEntryPage *page;
};


#endif
