/*
 *
 *  List of BT UUIDs and resolver for libtdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of libtdebluez.
 *
 *  libtdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libtdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


/*
 * This was taken from  bluez/lib/uuid.h 2018-07-22
 *
 */


#include <map>
#include <string>

#ifndef BTUUIDS_H_
#define BTUUIDS_H_

static const std::map<std::string, std::string> my_map =
{
    { "00001203-0000-1000-8000-00805f9b34fb", "Generic Audio" },
    { "00001108-0000-1000-8000-00805f9b34fb", "Headset" },
    { "00001112-0000-1000-8000-00805f9b34fb", "Headset AG" },

    { "0000111e-0000-1000-8000-00805f9b34fb", "Handsfree" },
    { "0000111f-0000-1000-8000-00805f9b34fb", "Handsfree AG" },

    { "0000110d-0000-1000-8000-00805f9b34fb", "Advanced Audio" },

    { "0000110a-0000-1000-8000-00805f9b34fb", "A2DP Source" }, //Advanced Audio Distribution Profile
    { "0000110b-0000-1000-8000-00805f9b34fb", "A2DP Sink" },

    { "0000110e-0000-1000-8000-00805f9b34fb", "A/V Remote Ctrl" }, //Audio/Video Remote Control Profile
    { "0000110c-0000-1000-8000-00805f9b34fb", "A/V Remote Ctrl Tgt" },

    { "00001115-0000-1000-8000-00805f9b34fb", "PANU" },
    { "00001116-0000-1000-8000-00805f9b34fb", "NAP" },
    { "00001117-0000-1000-8000-00805f9b34fb", "GN" },
    { "0000000f-0000-1000-8000-00805f9b34fb", "BNEP Service" }, //Bluetooth Network Encapsulation Protocol

    { "00002a50-0000-1000-8000-00805f9b34fb", "PNPID" },
    { "0000180a-0000-1000-8000-00805f9b34fb", "Device Information" },

    { "00001801-0000-1000-8000-00805f9b34fb", "GATT" }, //Generic Access Profile (Generic Attributes)
    { "00001802-0000-1000-8000-00805f9b34fb", "Immediate Alert" },
    { "00001803-0000-1000-8000-00805f9b34fb", "Link Loss" },
    { "00001804-0000-1000-8000-00805f9b34fb", "TX Power" },

    { "0000112d-0000-1000-8000-00805f9b34fb", "SAP" },

    { "0000180d-0000-1000-8000-00805f9b34fb", "Heart Rate" },
    { "00002a37-0000-1000-8000-00805f9b34fb", "Heart Rate Measurement" },
    { "00002a38-0000-1000-8000-00805f9b34fb", "Body Sensor Location" },
    { "00002a39-0000-1000-8000-00805f9b34fb", "Heart Rate Control Point" },

    { "00001809-0000-1000-8000-00805f9b34fb", "Health Thermometer" },
    { "00002a1c-0000-1000-8000-00805f9b34fb", "Temp Measurement" },
    { "00002a1d-0000-1000-8000-00805f9b34fb", "Temp Type" },
    { "00002a1e-0000-1000-8000-00805f9b34fb", "Immediate Temp" },
    { "00002a21-0000-1000-8000-00805f9b34fb", "Measurement Interval" },

    { "00001816-0000-1000-8000-00805f9b34fb", "Cycling SC" },
    { "00002a5b-0000-1000-8000-00805f9b34fb", "CSC Measurement" },
    { "00002a5c-0000-1000-8000-00805f9b34fb", "CSC Feature" },
    { "00002a5d-0000-1000-8000-00805f9b34fb", "Sensor Location" },
    { "00002a55-0000-1000-8000-00805f9b34fb", "SC Control Point" },

    { "00000003-0000-1000-8000-00805f9b34fb", "RFCOMM" },

    { "00001400-0000-1000-8000-00805f9b34fb", "HDP" },
    { "00001401-0000-1000-8000-00805f9b34fb", "HDP Source" },
    { "00001402-0000-1000-8000-00805f9b34fb", "HDP Sink" },

    { "00001124-0000-1000-8000-00805f9b34fb", "HID" },

    { "00001103-0000-1000-8000-00805f9b34fb", "DUN Gateway" }, //Dial-up Networking Profile

    { "00001800-0000-1000-8000-00805f9b34fb", "GAP" }, //Generic Access Profile
    { "00001200-0000-1000-8000-00805f9b34fb", "PNP" },

    { "00001101-0000-1000-8000-00805f9b34fb", "SPP" }, //Serial Port Profile

    { "00001104-0000-1000-8000-00805f9b34fb", "OBEX Sync" },
    { "00001105-0000-1000-8000-00805f9b34fb", "OBEX OPP" },
    { "00001106-0000-1000-8000-00805f9b34fb", "OBEX FTP" },
    { "f9ec7bc4-953c-11d2-984e-525400dc9e09", "OBEX DIR" },
    { "0000112e-0000-1000-8000-00805f9b34fb", "OBEX PCE" },
    { "0000112f-0000-1000-8000-00805f9b34fb", "OBEX PSE" },
    { "00001130-0000-1000-8000-00805f9b34fb", "OBEX PBAP" },
    { "00001132-0000-1000-8000-00805f9b34fb", "OBEX Msg Access Srv" },
    { "00001133-0000-1000-8000-00805f9b34fb", "OBEX Msg Notif. Srv" },
    { "00001134-0000-1000-8000-00805f9b34fb", "OBEX MAP" },
    // taken from
    // https://www.vistax64.com/threads/bluetooth-peripheral-device-cannot-be-found.62944/
    // https://together.jolla.com/question/64565/accessing-bluetooth-profiles/
    // http://www.sensi.org/~ak/tmp/n95.txt
    { "00005005-0000-1000-8000-0002ee000001", "Nokia PC Suite" },
    { "00005601-0000-1000-8000-0002ee000001", "Nokia SyncML Server" },
    { "00000001-0000-1000-8000-0002ee000001", "SyncML Server" },
    { "00000002-0000-1000-8000-0002ee000002", "OBEX Syncevolution" },
    { "00000004-0000-1000-8000-0002ee000002", "SyncML DM Client" }

};

/*!
 * This function resolves UUID to human readable service name.
 * \return string service name
 * \retval the service name
 */

static const TQString resolveUUID(const TQString &uuid)
{

    TQString name;

    for (auto i = my_map.begin(); i != my_map.end(); ++i)
    {
        if (i->first == uuid.latin1())
        {
            name = TQString(i->second.c_str());
            break;
        }
    }
    //		name = i18n("Unknown");
    return (!name.isEmpty()) ? name : uuid;
}

#endif // BTUUIDS_H_
