/*
 *
 *  Authorization dialog for kbluetooth
 *
 *  Copyright (C) 2006  Daniel Gollub <dgollub@suse.de>
 *
 *
 *  This file is part of kbluetooth.
 *
 *  kbluetooth is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libkbluetooth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libkbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "authorize.h"
#include "authdialog.h"

AuthorizeDialog::AuthorizeDialog(const TQString &addr, const TQString &devName, const TQString &service) :
        KDialogBase(NULL, "authrequest", true, "Bluetooth Authorization Request",
                (Ok | Cancel), Ok, false,
                KGuiItem(i18n("Accept"), "accept"),
                KGuiItem(i18n("Reject"), "reject"))
{
    TQString action;

    action = (service.isEmpty()
              ? i18n("<b>%1</b> (device address <b>%2</b>) wants to act as Input Device.")
              : i18n("<b>%1</b> (device address <b>%2</b>) wants to act as Input Device for %3.")).
             arg(devName).arg(addr).arg(service);

    authDlg = new AuthDialog(this);
    authDlg->messageLabel->setText(authDlg->messageLabel->text().arg(action));
    connect(this, TQ_SIGNAL(okClicked()), TQ_SLOT(close()));

    setMainWidget(authDlg);
}

AuthorizeDialog::~AuthorizeDialog()
{
    delete authDlg;
}

#include "authorize.moc"
