//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQRegExp;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQFontMetrics;

/**

 This class contains utility functions for handling strings.
 This class is <b>not</b> a substitute for the String class. What
 I tried to do with this class is provide an easy way to
 cut/slice/splice words inside sentences in whatever order desired.
 While the main focus of this class are words (ie characters
 separated by spaces/tabs), the two core functions here ( split()
 and join() ) will function given any char to use as a separator.
 This will make it easy to redefine what a 'word' means in the
 future if needed.
 I freely stole some of the function names from python. I also think
 some of these were influenced by mIRC (yes, believe it if you will, I
 used to write a LOT of scripts in mIRC).
 The ranges are a fairly powerful way of getting/stripping words from
 a string. These ranges function, for the large part, as they would in
 python. See the word(String, String ) and remword(String, uint) functions for more detail.
 This class contains no data members of its own. All strings are cut
 on the fly and returned as new qstrings/qstringlists.
 Quick example on how to use:
 <pre>
 KStringHandler kstr;
 String line = "This is a test of the strings";
 cout << "1> " << kstr.word( line , "4:" ) << "\n";
 cout << "2> " << kstr.remrange( line , "2:5" ) << "\n";
 cout << "2> " << kstr.reverse( line ) << "\n";
 cout << "2> " << kstr.center( kstr.word( line , 4 ) , 15 ) << "\n";
 </pre>
 and so forth.
		@author Ian Zepp <icszepp@islc.net>

		@short Class for manipulating words and sentences in strings.
		@see KShell

*/
public class KStringHandler implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KStringHandler(Class dummy){}

	public KStringHandler() {
		newKStringHandler();
	}
	private native void newKStringHandler();
	/**	 Returns a range of words from that string.
		 Ie:

			<li>
			"0" returns the very first word
			</li>

			<li>
			"0:" returns the first to the last word
			</li>

			<li>
			"0:3" returns the first to fourth words
			</li>

			<li>
			":3" returns everything up to the fourth word
			</li>
				 If you grok python, you're set.
			@param text the string to search for the words
			@param range the words to return (see description)
				@return the words, or an empty string if not found

		@short   Returns a range of words from that string.
	*/
	public static native String word(String text, String range);
	/**	 Inserts a word into the string, and returns
		 a new string with the word included. the first
		 index is zero (0). If there are not <code>pos</code> words in the original
		 string, the new word will be appended to the end.
			@param text the original text
			@param word the word to insert
			@param pos the position (in words) for the new word
				@return the resulting string

		@short   Inserts a word into the string, and returns  a new string with the word included.
	*/
	public static native String insword(String text, String word, int pos);
	/**	 Replaces a word in the string, and returns
		 a new string with the word included. the first
		 index is zero (0). If there are not <code>pos</code> words in the original
		 string, the new word will be appended to the end.
			@param text the original text
			@param word the word to insert
			@param pos the position (in words) for the new word
				@return the resulting string

		@short   Replaces a word in the string, and returns  a new string with the word included.
	*/
	public static native String setword(String text, String word, int pos);
	/**	 Removes a word or ranges of words from the string,
		 and returns a new string. The ranges definitions
		 follow the definitions for the word() function.

			<li>
			"0"        removes the very first word
			</li>

			<li>
			"0:"    removes the first the the last word
			</li>

			<li>
			"0:3"    removes the first to fourth words
			</li>

			<li>
			":3"    removes everything up to the fourth word
			</li>
				@param text the original text
			@param range the words to remove (see description)
				@return the resulting string

		@short   Removes a word or ranges of words from the string,  and returns a new string.
	*/
	public static native String remrange(String text, String range);
	/**	 Removes a word at the given index, and returns a
		 new string. The first index is zero (0).
			@param text the original text
			@param pos the position (in words) of thw word to delete
				@return the resulting string

		@short   Removes a word at the given index, and returns a  new string.
	*/
	public static native String remword(String text, int pos);
	/**	 Removes a matching word from the string, and returns
		 a new string. Note that only ONE match is removed.
			@param text the original text
			@param word the word to remove
				@return the resulting string

		@short   Removes a matching word from the string, and returns  a new string.
	*/
	public static native String remword(String text, String word);
	/**	 Capitalizes each word in the string
		 "hello there" becomes "Hello There"        (string)
			@param text the text to capitalize
				@return the resulting string

		@short   Capitalizes each word in the string  "hello there" becomes "Hello There"        (string)
	*/
	public static native String capwords(String text);
	/**	 Capitalizes each word in the list
		 [hello, there] becomes [Hello, There]    (list)
			@param list the list to capitalize
				@return the resulting list

		@short   Capitalizes each word in the list  [hello, there] becomes [Hello, There]    (list)
	*/
	public static native ArrayList capwords(String[] list);
	/**	 Reverses the order of the words in a string
		 "hello there" becomes "there hello"        (string)
			@param text the text to reverse
				@return the resulting string

		@short   Reverses the order of the words in a string  "hello there" becomes "there hello"        (string)
	*/
	public static native String reverse(String text);
	/**	 Reverses the order of the words in a list
		 [hello, there] becomes [there, hello]    (list)
			@param list the list to reverse
				@return the resulting list

		@short   Reverses the order of the words in a list  [hello, there] becomes [there, hello]    (list)
	*/
	public static native ArrayList reverse(String[] list);
	/**	 Centers a string and returns a string at least 'width' characters
		 wide.
		 If the string is longer than the <code>width</code>, the original
		 string is returned. It is never truncated.
			@param text the text to justify
			@param width the desired width of the new string
				@return the resulting string

		@short   Centers a string and returns a string at least 'width' characters  wide.
	*/
	public static native String center(String text, int width);
	/**	 Substitute characters at the beginning of a string by "...".
			@param str is the string to modify
			@param maxlen is the maximum length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the beginning of a string by ".
	*/
	public static native String lsqueeze(String str, int maxlen);
	public static native String lsqueeze(String str);
	/**	 Substitute characters at the beginning of a string by "...". Similar to
		 method above, except that it truncates based on pixel width rather than
		 the number of characters
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxlen is the maximum length in ems the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the beginning of a string by ".
	*/
	public static native String lEmSqueeze(String name, TQFontMetrics fontMetrics, int maxlen);
	public static native String lEmSqueeze(String name, TQFontMetrics fontMetrics);
	/**	 Substitute characters at the beginning of a string by "...". Similar to
		 method above, except that maxlen is the width in pixels to truncate to
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxPixels is the maximum pixel length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the beginning of a string by ".
	*/
	public static native String lPixelSqueeze(String name, TQFontMetrics fontMetrics, int maxPixels);
	/**	 Substitute characters at the middle of a string by "...".
			@param str is the string to modify
			@param maxlen is the maximum length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the middle of a string by ".
	*/
	public static native String csqueeze(String str, int maxlen);
	public static native String csqueeze(String str);
	/**	 Substitute characters in the middle of a string by "...". Similar to
		 method above, except that it truncates based on pixel width rather than
		 the number of characters
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxlen is the maximum length in ems the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters in the middle of a string by ".
	*/
	public static native String cEmSqueeze(String name, TQFontMetrics fontMetrics, int maxlen);
	public static native String cEmSqueeze(String name, TQFontMetrics fontMetrics);
	/**	 Substitute characters in the middle of a string by "...". Similar to
		 method above, except that maxlen is the width in pixels to truncate to
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxPixels is the maximum pixel length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters in the middle of a string by ".
	*/
	public static native String cPixelSqueeze(String name, TQFontMetrics fontMetrics, int maxPixels);
	/**	 Substitute characters at the end of a string by "...".
			@param str is the string to modify
			@param maxlen is the maximum length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the end of a string by ".
	*/
	public static native String rsqueeze(String str, int maxlen);
	public static native String rsqueeze(String str);
	/**	 Substitute characters at the end of a string by "...". Similar to
		 method above, except that it truncates based on pixel width rather than
		 the number of characters
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxlen is the maximum length in ems the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the end of a string by ".
	*/
	public static native String rEmSqueeze(String name, TQFontMetrics fontMetrics, int maxlen);
	public static native String rEmSqueeze(String name, TQFontMetrics fontMetrics);
	/**	 Substitute characters at the end of a string by "...". Similar to
		 method above, except that maxlen is the width in pixels to truncate to
			@param name is the string to modify
			@param fontMetrics is the font metrics to use to calculate character sizes
			@param maxPixels is the maximum pixel length the modified string will have
		 If the original string is shorter than "maxlen", it is returned verbatim
				@return the modified string

		@short   Substitute characters at the end of a string by ".
	*/
	public static native String rPixelSqueeze(String name, TQFontMetrics fontMetrics, int maxPixels);
	/**
		 Match a filename.
			@param filename is the real decoded filename (or dirname
		        without trailing '/').
			@param pattern is a pattern like .txt, .tar.gz, Makefile., README, etc.
		 Patterns with two asterisks like "*.pk" are not supported.
				@return true if the given filename matches the given pattern

		@short    Match a filename.
	*/
	public static native boolean matchFileName(String filename, String pattern);
	/**
		 Split a String into an ArrayList in a similar fashion to the static
		 ArrayList function in Qt, except you can specify a maximum number
		 of tokens. If max is specified (!= 0) then only that number of tokens
		 will be extracted. The final token will be the remainder of the string.
			 Example:
		 <pre>
		 perlSplit("__", "some__string__for__you__here", 4)
		 ArrayList contains: "some", "string", "for", "you__here"
		 </pre>
			@param sep is the string to use to delimit s.
			@param s is the input string
			@param max is the maximum number of extractions to perform, or 0.
				@return An ArrayList containing tokens extracted from s.

		@short    Split a String into an ArrayList in a similar fashion to the static  ArrayList function in Qt, except you can specify a maximum number  of tokens.
	*/
	public static native ArrayList perlSplit(String sep, String s, int max);
	public static native ArrayList perlSplit(String sep, String s);
	/**
		 Split a String into an ArrayList in a similar fashion to the static
		 ArrayList function in Qt, except you can specify a maximum number
		 of tokens. If max is specified (!= 0) then only that number of tokens
		 will be extracted. The final token will be the remainder of the string.
			 Example:
		 <pre>
		 perlSplit(' ', "tdeparts reaches the parts other parts can't", 3)
		 ArrayList contains: "tdeparts", "reaches", "the parts other parts can't"
		 </pre>
			@param sep is the character to use to delimit s.
			@param s is the input string
			@param max is the maximum number of extractions to perform, or 0.
				@return An ArrayList containing tokens extracted from s.

		@short    Split a String into an ArrayList in a similar fashion to the static  ArrayList function in Qt, except you can specify a maximum number  of tokens.
	*/
	public static native ArrayList perlSplit(char sep, String s, int max);
	public static native ArrayList perlSplit(char sep, String s);
	/**
		 Split a String into an ArrayList in a similar fashion to the static
		 ArrayList function in Qt, except you can specify a maximum number
		 of tokens. If max is specified (!= 0) then only that number of tokens
		 will be extracted. The final token will be the remainder of the string.
			 Example:
		 <pre>
		 perlSplit(TQRegExp("[! ]", "Split me up ! I'm bored ! OK ?", 3)
		 ArrayList contains: "Split", "me", "up ! I'm bored, OK ?"
		 </pre>
			@param sep is the regular expression to use to delimit s.
			@param s is the input string
			@param max is the maximum number of extractions to perform, or 0.
				@return An ArrayList containing tokens extracted from s.

		@short    Split a String into an ArrayList in a similar fashion to the static  ArrayList function in Qt, except you can specify a maximum number  of tokens.
	*/
	public static native ArrayList perlSplit(TQRegExp sep, String s, int max);
	public static native ArrayList perlSplit(TQRegExp sep, String s);
	/**
		 This method auto-detects URLs in strings, and adds HTML markup to them
		 so that richtext or HTML-enabled widgets (such as KActiveLabel)
		 will display the URL correctly.
			@param text the string which may contain URLs
				@return the resulting text

		@short    This method auto-detects URLs in strings, and adds HTML markup to them  so that richtext or HTML-enabled widgets (such as KActiveLabel)  will display the URL correctly.
	*/
	public static native String tagURLs(String text);
	/**
		      Obscure string by using a simple symmetric encryption. Applying the
		      function to a string obscured by this function will result in the original
		      string.
			      The function can be used to obscure passwords stored to configuration
		      files. Note that this won't give you any more security than preventing
		      that the password is directly copied and pasted.
			@param str string to be obscured
				@return obscured string

		@short         Obscure string by using a simple symmetric encryption.
	*/
	public static native String obscure(String str);
	/**
		      Guess whether a string is UTF8 encoded.
			@param str the string to check
				@return true if UTF8. If false, the string is probably in Local8Bit.

		@short         Guess whether a string is UTF8 encoded.
	*/
	public static native boolean isUtf8(String str);
	/**
		      Construct String from a c string, guessing whether it is UTF8- or
		      Local8Bit-encoded.
			@param str the input string
				@return the (hopefully correctly guessed) String representation of <code>str</code>

		@short         Construct String from a c string, guessing whether it is UTF8- or       Local8Bit-encoded.
	*/
	public static native String from8Bit(String str);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
