// Qt# tutorial 3
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;


public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		TQVBox box = new TQVBox ();
		box.Resize (200, 120);
		
		TQPushButton quit = new TQPushButton ("Quit", box);
		quit.SetFont (new TQFont ("Times", 18, TQFont.Weight.Bold));
		// In C++, TQFont::Bold is sufficient
		
		TQObject.Connect ( quit, QtSupport.TQ_SIGNAL ("clicked()"), a, QtSupport.TQ_SLOT ("Quit()") );
		// TQ_SIGNAL and TQ_SLOT are static functions of QtSupport
				
		a.SetMainWidget (box);
		box.Show ();
		return a.Exec ();
	}
}
