/* kasgroupitem.h
**
** Copyright (C) 2001-2004 Richard Moore <rich@kde.org>
** Contributor: Mosfet
**     All rights reserved.
**
** KasBar is dual-licensed: you can choose the GPL or the BSD license.
** Short forms of both licenses are included below.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/
#ifndef KASGROUPITEM_H
#define KASGROUPITEM_H

#include <tqpixmap.h>
#include <taskmanager.h>
#include "kasitem.h"

class KasPopup;
class KasTasker;
class KPixmap;
class Task;

/**
 * A KasItem that holds a list of Tasks.
 */
class KasGroupItem : public KasItem
{
   TQ_OBJECT

public:
   enum GroupType {
       GroupRelated, GroupDesktop
   };

   KasGroupItem( KasTasker *parent/*, Group *group*/ );
   virtual ~KasGroupItem();

   uint groupType() const { return groupType_; }
   void setGroupType( uint type ) { groupType_ = type; }

   /** Reimplemented to paint the item. */
   virtual void paint( TQPainter *p );

   KasTasker *kasbar() const;

   Task::Ptr task( uint i ) { return items.at( i ); }
   int taskCount() const { return items.count(); }

   TQPixmap icon();
  
public slots:
   void addTask( Task::Ptr t );
   void removeTask( Task::Ptr t );

   void ungroup();

   void showGroupMenuAt( TQMouseEvent *ev );   
   void showGroupMenuAt( const TQPoint &p );

   void updateIcon();

   void updatePopup();

protected:
   /** Reimplemented to create a KasGroupPopup. */
   virtual KasPopup *createPopup();

private:
   TQString title_;
   Task::List items;
   uint groupType_;
   KasTasker *bar;
};

#endif // KASGROUPITEM_H

