/*
 *  Copyright (c) 1998 Denis Perchine <dyp@perchine.com>
 *  Copyright (c) 2004 Szombathelyi György <gyurco@freemail.hu>
 *  Maintained by Adriaan de Groot <groot@kde.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef _KU_PROPDLG_H_
#define _KU_PROPDLG_H_

#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqwidget.h>
#include <tqlistbox.h>
#include <tqtooltip.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqmap.h>

#include <klineedit.h>
#include <kdatetimewidget.h>
#include <knuminput.h>
#include <kdialogbase.h>
#include <tdelistview.h>
#include <kcombobox.h>

#include "kuser.h"

class propdlg : public KDialogBase
{
  TQ_OBJECT
  

public:
  propdlg( const TQPtrList<KU::KUser> &users,
    TQWidget *parent = 0, const char *name = 0 );
  propdlg( KU::KUser *AUser, bool fixedprivgroup, 
    TQWidget *parent = 0, const char *name = 0 );
  ~propdlg();

  void mergeUser( KU::KUser *user, KU::KUser *newuser );

protected slots:
  virtual void slotOk();
  void setpwd();
  void changed(); // Change to misc settings
  void cbposixChanged(); // Change to diaable POSIX account info
  void cbsambaChanged(); // Change to diaable POSIX account info
  void gchanged(); // Change to group settings
  void setpgroup(); // Change in primary group

protected:
  void initDlg();
  void selectuser();
  void save();
  bool saveg();
  bool check();
  void loadgroups( bool fixedprivgroup );
  bool checkShell(const TQString &shell);
  void addRow( TQWidget *parent, TQGridLayout *layout, int row, 
  TQWidget *widget, const TQString &label, const TQString &what, 
  bool two_column=true, bool nochange=true );
  void setLE( KLineEdit *le, const TQString &val, bool first );
  void setCB( TQCheckBox *cb, bool val, bool first );
  void setSB( KIntSpinBox *sb, int val, bool first );
  TQString mergeLE( KLineEdit *le, const TQString &val, bool one );
  int mergeSB( KIntSpinBox *sb, int val, bool one );

  KIntSpinBox *addDaysGroup( TQWidget  *parent, TQGridLayout *layout, int row, 
    const TQString &title, bool never=true );

  TQFrame *frontpage;
  TQGridLayout *frontlayout;
  int frontrow;

  TQPtrList<KU::KUser> mUsers;
  TQMap<TQWidget*, TQCheckBox*> mNoChanges;
  bool ismoreshells;
  bool ischanged;
  bool isgchanged;
  uid_t olduid;
  uint oldrid;
  TQString oldshell;
  TQString  primaryGroup;
  bool  primaryGroupWasOn;
  bool ro;

  TQString newpass;
  time_t lstchg;

  TDEListView *lstgrp;

  TQPushButton *pbsetpwd;

  TQLabel      *lbuser;
  KLineEdit   *leid;
  KLineEdit   *lefname;
  KLineEdit   *lesurname;
  KLineEdit   *lemail;

  KComboBox   *leshell;
  KLineEdit   *lehome;

  KLineEdit   *leoffice;
  KLineEdit   *leophone;
  KLineEdit   *lehphone;
  KLineEdit   *leclass;

  KLineEdit   *leoffice1;
  KLineEdit   *leoffice2;
  KLineEdit   *leaddress;

  TQCheckBox   *cbdisabled;
  TQCheckBox   *cbposix;
  TQCheckBox   *cbsamba;
  TQLabel      *leprigr;
  TQPushButton *pbprigr;

  TQLabel *leslstchg;
  KIntSpinBox *lesmin;
  KIntSpinBox *lesmax;
  KIntSpinBox *leswarn;
  KIntSpinBox *lesinact;
  KDateTimeWidget  *lesexpire;
  TQCheckBox *cbexpire;

//samba specific:  
  KLineEdit   *lerid;
  KLineEdit   *leliscript;
  KLineEdit   *leprofile;
  KLineEdit   *lehomedrive;
  KLineEdit   *lehomepath;
  KLineEdit   *leworkstations;
  KLineEdit   *ledomain;
  KLineEdit   *ledomsid;
};

#endif // _KU_PROPDLG_H_

