/* This file is part of the KDE project

   Copyright (C) 2004 Gary Cramblitt <garycramblitt@comcast.net>

   Adapted from tdeutils/ark/konqplugin by
        Georg Robbers <Georg.Robbers@urz.uni-hd.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "akregatorplugin.h"
#include "pluginbase.h"

#include <tdeapplication.h>
#include <kmimetype.h>
#include <kdebug.h>
#include <tdeaction.h>
#include <tdeinstance.h>
#include <tdelocale.h>
#include <konq_popupmenu.h>
#include <tdepopupmenu.h>
#include <kgenericfactory.h>
#include <kurl.h>
#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <tdemessagebox.h>

#include <tqdir.h>
#include <tqcstring.h>
#include <tqobject.h>
#include <tqstringlist.h>

using namespace Akregator;

typedef KGenericFactory<AkregatorMenu, KonqPopupMenu> AkregatorMenuFactory;
K_EXPORT_COMPONENT_FACTORY( libakregatorkonqplugin, AkregatorMenuFactory("akregatorkonqplugin") )

AkregatorMenu::AkregatorMenu( KonqPopupMenu * popupmenu, const char *name, const TQStringList& /* list */ )
    : KonqPopupMenuPlugin( popupmenu, name), PluginBase(), m_conf(0), m_part(0)
{
    kdDebug() << "AkregatorMenu::AkregatorMenu()" << endl;
    if ( TQCString( tdeApp->name() ) == "kdesktop" && !tdeApp->authorize("editable_desktop_icons" ) )
        return;

    // Do nothing if user has turned us off.
    // TODO: Not yet implemented in aKregator settings.
    /*m_conf = new TDEConfig( "akregatorrc" );
    m_conf->setGroup( "AkregatorKonqPlugin" );
    if ( !m_conf->readBoolEntry( "Enable", true ) )
        return;
    */
    
    TDEHTMLView* view = 0L;
          
    if (popupmenu && popupmenu->parent() && popupmenu->parent()->inherits("TDEHTMLView"))
            view = static_cast<TDEHTMLView*>(popupmenu->parent());
    
    if (view)
        m_part = view->part();
     
    TDEGlobal::locale()->insertCatalogue("akregator_konqplugin");
    m_feedMimeTypes << "text/rss" << "text/rdf" << "text/xml";
    // Get the list of URLs clicked on from Konqi.
    //KFileItemList m_list = popupmenu->fileItemList();
    // See if any are RSS feeds.
    
    KFileItemList list = popupmenu->fileItemList();
    KFileItem* it = list.first();
    while (it != 0)
    {
	if (isFeedUrl(it))
        {
	    kdDebug() << "AkregatorMenu: found feed URL " << it->url().prettyURL() << endl;
            TDEAction *action = new TDEAction( i18n( "Add Feed to Akregator" ), "akregator", 0, this, TQ_SLOT( slotAddFeed() ), actionCollection(), "akregatorkonqplugin_mnu" );
            addAction( action );
            addSeparator();
	    m_feedURL = it->url().url();
            break;
        }
	
	it = list.next();
    }
}

AkregatorMenu::~AkregatorMenu()
{
    TDEGlobal::locale()->removeCatalogue("akregator_konqplugin");
    delete m_conf;
}

bool AkregatorMenu::isFeedUrl(const TQString &url)
{
    if (url.contains(".htm", false) != 0) return false;
    if (url.contains("rss", false) != 0) return true;
    if (url.contains("rdf", false) != 0) return true;
    if (url.contains("xml", false) != 0) return true;
    return false;
}

bool AkregatorMenu::isFeedUrl(const KFileItem * item)
{
    if ( m_feedMimeTypes.contains( item->mimetype() ) )
        return true;
    else
    {
        TQString url = item->url().url();
        // If URL ends in .htm or .html, it is not a feed url.
        return isFeedUrl(url);
    }
    return false;
}

void AkregatorMenu::slotAddFeed()
{
    TQString url = m_part ? fixRelativeURL(m_feedURL, m_part->baseURL()) : m_feedURL; 
    if(akregatorRunning())
      addFeedsViaDCOP(TQStringList(url));
    else
        addFeedViaCmdLine(url);
}

#include "akregatorplugin.moc"
