
#include "replaygain.h"
#include "configuration.h"
#include "logger.h"
#include "replaygainpluginloader.h"

#include <tqfile.h>

#include <tdeprocess.h>
#include <tdelocale.h>
#include <kurl.h>

ReplayGain::ReplayGain( Config* _config, Logger* _logger )
{
    config = _config;
    logger = _logger;
}

ReplayGain::~ReplayGain()
{}

bool ReplayGain::apply( TQStringList files, const TQString& format, TDEProcess* proc, int logID, Mode mode )
{
    TQStringList params;
    TQString param, paramSplinter;

    proc->clearArguments();

    ReplayGainPlugin* plugin = config->replaygainForFormat( format );
    if( plugin == 0 ) { // shouldn't happen
        logger->log( logID, " NULL POINTER: ReplayGain::replaygain( ... ) / plugin" );
        return false;
    }

    param = TQString();
    if( !plugin->replaygain.param.isEmpty() ) param.append( " " + plugin->replaygain.param );
    if( mode & remove ) {
        if( !plugin->replaygain.remove.isEmpty() ) param.append( " " + plugin->replaygain.remove );
    }
    else {
        if( (mode & calc_track) && !plugin->replaygain.track.isEmpty() ) param.append( " " + plugin->replaygain.track );
        if( (mode & calc_album) && !plugin->replaygain.album.isEmpty() ) param.append( " " + plugin->replaygain.album );
        if( mode & force ) {
            if( !plugin->replaygain.force.isEmpty() ) param.append( " " + plugin->replaygain.force );
        }
        else {
            if( !plugin->replaygain.skip.isEmpty() ) param.append( " " + plugin->replaygain.skip );
        }
    }

//     if( plugin->replaygain.in_files.find("%p") != -1 ) {
//         TQString t_str = plugin->replaygain.in_files;
//         t_str.replace( "%p", param );
//         param = plugin->replaygain.bin + " " + t_str;
//     }
//     else {
//         param = plugin->replaygain.bin + param + " " + plugin->replaygain.in_files;
//     }

    TQString t_str = plugin->replaygain.in_files;
    t_str.replace( "%p", param );
    param = config->binaries[plugin->replaygain.bin] + " " + t_str;

    // cosmetic surgery
    param.simplifyWhiteSpace();

    params = TQStringList::split( ' ', param );

    for( TQStringList::Iterator it = params.begin(); it != params.end(); ++it )
    {
        paramSplinter = *it;
        if( paramSplinter == "%i" ) {
            for( TQStringList::Iterator b = files.begin(); b != files.end(); ++b ) {
                *(proc) << KURL::decode_string( *b );
            }
        }
        else {
            *(proc) << paramSplinter;
        }
    }

    for( TQStringList::Iterator it = files.begin(); it != files.end(); ++it )
    {
        *it = KURL::decode_string( *it );
    }

    param.replace( "%i", "\""+files.join("\" \"")+"\"" );
    logger->log( logID, " " + i18n("Executing") + ": `" + param + "'" );

    proc->setPriority( config->data.general.priority );
    proc->start( TDEProcess::NotifyOnExit, TDEProcess::AllOutput );

    return true;
}

//TQValueList<float> ReplayGain::getReplayGain( TQString file ) {} // obsolete

#include "replaygain.moc"
