
#include "options.h"
#include "optionssimple.h"
#include "optionsdetailed.h"
#include "configuration.h"

#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqfile.h>
#include <tqcolor.h>

#include <tdelocale.h>
#include <ktabwidget.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <tdeio/job.h>
#include <tdestandarddirs.h>

// FIXME prevent converting wav files to wav

Options::Options( Config* _config, const TQString &text, TQWidget *parent, const char *name )
    : TQWidget( parent, name )
{
    config = _config;
    connect( config, TQ_SIGNAL(configChanged()),
               this, TQ_SLOT(configChanged())
             );

    TQGridLayout *gridLayout = new TQGridLayout( this, 1, 1 );

    tab = new KTabWidget( this, "tab" );

    optionsDetailed = new OptionsDetailed( config, this, "optionsDetailed" );
    optionsSimple = new OptionsSimple( config, optionsDetailed, text, this, "optionsSimple" );

    tab->addTab( optionsSimple, i18n("Simple") );
    connect( optionsSimple, TQ_SIGNAL(optionsChanged()),
             this, TQ_SLOT(somethingChanged())
           );

    tab->addTab( optionsDetailed, i18n("Detailed") );
    connect( optionsDetailed, TQ_SIGNAL(optionsChanged()),
             this, TQ_SLOT(somethingChanged())
           );

//     connect( optionsSimple, TQ_SIGNAL(setFormat(const TQString&)),
//              optionsDetailed, TQ_SLOT(setFormat(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setQualityMode(const TQString&)),
//              optionsDetailed, TQ_SLOT(setQualityMode(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setQuality(int)),
//              optionsDetailed, TQ_SLOT(setQuality(int))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setBitrateMode(const TQString&)),
//              optionsDetailed, TQ_SLOT(setBitrateMode(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setBitrateRangeEnabled(bool)),
//              optionsDetailed, TQ_SLOT(setBitrateRangeEnabled(bool))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setMinBitrate(int)),
//              optionsDetailed, TQ_SLOT(setMinBitrate(int))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setMaxBitrate(int)),
//              optionsDetailed, TQ_SLOT(setMaxBitrate(int))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setSamplingrateEnabled(bool)),
//              optionsDetailed, TQ_SLOT(setSamplingrateEnabled(bool))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setSamplingrate(int)),
//              optionsDetailed, TQ_SLOT(setSamplingrate(int))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setSamplingrate(const TQString&)),
//              optionsDetailed, TQ_SLOT(setSamplingrate(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setChannelsEnabled(bool)),
//              optionsDetailed, TQ_SLOT(setChannelsEnabled(bool))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setChannels(const TQString&)),
//              optionsDetailed, TQ_SLOT(setChannels(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setReplayGainEnabled(bool)),
//              optionsDetailed, TQ_SLOT(setReplayGainEnabled(bool))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setOutputDirectoryMode(OutputDirectory::Mode)),
//              optionsDetailed, TQ_SLOT(setOutputDirectoryMode(OutputDirectory::Mode))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setOutputDirectoryPath(const TQString&)),
//              optionsDetailed, TQ_SLOT(setOutputDirectoryPath(const TQString&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setOptions(const ConversionOptions&)),
//              optionsDetailed, TQ_SLOT(setCurrentOptions(const ConversionOptions&))
//            );
//     connect( optionsSimple, TQ_SIGNAL(setUserOptions(const TQString&)),
//              optionsDetailed, TQ_SLOT(setUserOptions(const TQString&))
//            );

    if( config->data.general.startTab == 0 ) tab->setCurrentPage( config->data.general.lastTab );
    else tab->setCurrentPage( config->data.general.startTab - 1 );
    gridLayout->addWidget( tab, 0, 0 );
    connect( tab, TQ_SIGNAL( currentChanged(TQWidget*) ),
              this, TQ_SLOT( tabChanged(TQWidget*) )
             );

    // draw the toggle button
    TQVBoxLayout *optionsTopBox = new TQVBoxLayout( -1, "optionsTopBox" );
    gridLayout->addLayout( optionsTopBox, 0, 0 );

    TQHBoxLayout *optionsBox = new TQHBoxLayout( 6, "optionsBox" );
    optionsTopBox->addLayout( optionsBox );
    optionsTopBox->addStretch();

    optionsBox->addStretch();

//     pPluginsNotify = new KPushButton( "", this, "pPluginsNotify");
//     pPluginsNotify->setPixmap( TDEGlobal::iconLoader()->loadIcon("connect_creating",TDEIcon::Toolbar) );
//     TQToolTip::add( pPluginsNotify, i18n("There are new plugin updates available.\nClick on this button in order to open the configuration dialog.") );
//     pPluginsNotify->hide();
//     pPluginsNotify->setPaletteBackgroundColor( TQColor(255,220,247) );
//     optionsBox->addWidget( pPluginsNotify );
//     connect( pPluginsNotify, TQ_SIGNAL(clicked()),
//                this, TQ_SLOT(showConfigDialogPlugins())
//              );

    pBackendsNotify = new KPushButton( "", this, "pBackendsNotify");
    pBackendsNotify->setPixmap( TDEGlobal::iconLoader()->loadIcon("preferences-system",TDEIcon::Toolbar) );
    TQToolTip::add( pBackendsNotify, i18n("soundKonverter either found new backends or misses some.\nClick on this button in order to open the configuration dialog.") );
    pBackendsNotify->setShown( config->backendsChanged );
    config->backendsChanged = false;
    pBackendsNotify->setPaletteBackgroundColor( TQColor(255,220,247) );
    optionsBox->addWidget( pBackendsNotify );
    connect( pBackendsNotify, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(showConfigDialogBackends())
             );

    pAdvancedOptionsToggle = new KPushButton( i18n("Advanced Options"), this, "pAdvancedOptionsToggle");
    pAdvancedOptionsToggle->setToggleButton( true );
    pAdvancedOptionsToggle->hide();
    optionsBox->addWidget( pAdvancedOptionsToggle );
    connect( pAdvancedOptionsToggle, TQ_SIGNAL(clicked()),
               optionsDetailed, TQ_SLOT(toggleAdvancedOptions())
             );
/* NOTE kaligames.de is down
    if( config->data.plugins.checkForUpdates ) {
        config->onlinePluginsChanged = false;
        getPluginListJob = TDEIO::file_copy("http://kaligames.de/downloads/soundkonverter/plugins/download.php?version=" + TQString::number(config->data.app.configVersion),
            locateLocal("data","soundkonverter/pluginlist_new.txt"), -1, true, false, false );
        connect( getPluginListJob, TQ_SIGNAL(result(TDEIO::Job*)),
                   this, TQ_SLOT(getPluginListFinished(TDEIO::Job*))
                 );
    }
*/
    if( config->data.general.defaultProfile == i18n("Last used") || config->getAllProfiles().findIndex(config->data.general.defaultProfile) != -1 ) {
        setCurrentOptions( config->getProfile(config->data.general.defaultProfile) );
    }
    else {
        setProfile( config->data.general.defaultProfile );
        setFormat( config->data.general.defaultFormat );
    }
}

Options::~Options()
{}

// void Options::getPluginListFinished( TDEIO::Job* job )
// {
//     if( job->error() == 0 ) {
//         TQFile file( locateLocal("data","soundkonverter/pluginlist.txt") );
//         TQFile newFile( locateLocal("data","soundkonverter/pluginlist_new.txt") );
// 
//         if( !file.exists() ) { // TODO check against the installed plugins
//             pPluginsNotify->show();
//             TDEIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//             config->onlinePluginsChanged = true;
//             return;
//         }
// 
//         if( file.open(IO_ReadOnly) && newFile.open(IO_ReadOnly) ) {
//             TQTextStream stream( &file );
//             TQTextStream newStream( &newFile );
//             while( !stream.atEnd() && !newStream.atEnd() ) {
//                 if( stream.readLine() != newStream.readLine() ) {
//                     file.close();
//                     newFile.close();
//                     pPluginsNotify->show();
//                     TDEIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//                     config->onlinePluginsChanged = true;
//                     return;
//                 }
//             }
//             if( stream.atEnd() != newStream.atEnd() ) {
//                 file.close();
//                 newFile.close();
//                 pPluginsNotify->show();
//                 TDEIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//                 config->onlinePluginsChanged = true;
//                 return;
//             }
//             file.close();
//             newFile.close();
//         }
//         newFile.remove();
//     }
// }

// void Options::showConfigDialogPlugins()
// {
//     pPluginsNotify->hide();
//     emit showConfigPluginsPage();
// }

void Options::showConfigDialogBackends()
{
    pBackendsNotify->hide();
    emit showConfigEnvironmentPage();
}

ConversionOptions Options::getCurrentOptions()
{
    return optionsDetailed->getCurrentOptions();
}

void Options::setCurrentOptions( const ConversionOptions& options )
{
    optionsDetailed->setCurrentOptions( options );
    /*if( tab->page(tab->currentPageIndex()) == optionsSimple ) {
        optionsSimple->refill();
    }*/
    optionsSimple->refill();
}

void Options::tabChanged( TQWidget* widget )
{
    if( widget == optionsSimple ) {
        pAdvancedOptionsToggle->hide();
        optionsSimple->refill();
    }
    else {
        pAdvancedOptionsToggle->show();
    }
    config->data.general.lastTab = tab->currentPageIndex();
}

void Options::setProfile( const TQString& profile )
{
    optionsSimple->setCurrentProfile( profile );
}

void Options::setFormat( const TQString& format )
{
    optionsSimple->setCurrentFormat( format );
}

void Options::setOutputDirectory( const TQString& directory )
{
    optionsSimple->setCurrentOutputDirectory( directory );
}

void Options::somethingChanged()
{
    emit optionsChanged();
}

// TODO right this way? - seems to work
void Options::configChanged()
{
    optionsDetailed->refill();
    /*if( tab->page(tab->currentPageIndex()) == optionsSimple ) {
        optionsSimple->refill();
    }*/
    optionsSimple->refill();
}

#include "options.moc"
