/***************************************************************************
    smb4ksearchdialog  -  The search dialog widget of Smb4K.
                             -------------------
    begin                : Sa Jun 2 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSEARCHDIALOG_H
#define SMB4KSEARCHDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqwidget.h>
#include <tqstring.h>

// KDE includes
#include <tdelistview.h>
#include <tdetoolbar.h>

// forward declarations
class Smb4KHostItem;


/**
 * This is the search dialog. It enables the user to find servers,
 * that were not found by the regular network scan.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */


class Smb4KSearchDialog : public TQWidget
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parent      The parent widget
     *
     * @param name        The name of this widget
     */
    Smb4KSearchDialog( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSearchDialog();

    /**
     * This enumeration determines the place where the tool bar
     * widgets are located.
     */
    enum ToolBarWidgets { Combo = 0, Search, Clear, Add };

    /**
     * Returns the search string the user entered. It's the current
     * text of the combo box.
     *
     * @returns the search string.
     */
    const TQString &searchString();

    /**
     * This function returns a pointer to the list view of this widget.
     *
     * @returns a pointer to the list view of this widget.
     */
    TDEListView *listView() { return m_list_view; }

    /**
     * This function returns a pointer to the tool bar of this widget.
     *
     * @returns a pointer to the tool bar of this widget.
     */
    TDEToolBar *toolBar() { return m_tool_bar; }

  signals:
    /**
     * This signal is emitted everytime a button of the tool bar
     * or the return key has been clicked. It passes the button id
     * according to the ToolBarWidgets enumeration.
     *
     * @param button_id   The button id
     */
    void buttonPressed( int button_id );

  protected slots:
    /**
     * This slot is called when the search text has been entered
     * and the return key has been pressed.
     */
    void slotReturnPressed();

    /**
     * This slot is activated when the text in the edit line of the
     * combo box changed. It is used to enable and disable buttons.
     *
     * @param text        The text input
     */
    void slotTextChanged( const TQString &text );

    /**
     * This slot is activated when a button in the tool bar is pressed.
     * It emits the buttonPressed() signal that can be processed by the
     * KPart or other widgets. Additionally, it also executes those things
     * that need not be done outside the widget, like clearing all the
     * list box and the combo box.
     *
     * @param button_id   The button id according to the ToolBarWidgets
     *                    enumeration.
     */
    void slotButtonPressed( int button_id );

    /**
     * This slot is activated when the user clicked into the list view. It
     * is used to disable the "Add" button in the tool bar when no item is
     * selected, i.e. the user clicked on the viewport. The rest is done by
     * slotSelectionChanged().
     *
     * @param item        The list box item that the user clicked or NULL if
     *                    he clicked onto the viewport.
     */
    void slotItemClicked( TQListViewItem *item );

    /**
     * This slot is activated when the selection changed in the list view.
     * It is used to enable/disable the "Add" button in the tool bar.
     *
     * @param item        The list box item that's currently selected
     */
    void slotSelectionChanged( TQListViewItem *item );

  private:
    /**
     * The current search string
     */
    TQString m_search_string;

    /**
     * The list box of this widget
     */
    TDEListView *m_list_view;

    /**
     * The tool bar of this widget
     */
    TDEToolBar *m_tool_bar;
};

#endif
