#!/usr/bin/env python

#****************************************************************************
#** $Id: sqltable4.py,v 1.3 2002/07/06 13:35:41 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyTQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
from PyTQt.tqt import *
from PyTQt.tqtsql import *

from dbconnect import createConnection

TRUE  = 1
FALSE = 0

class CustomTable(TQDataTable):
    def __init__(self, cursor, autoPopulate = FALSE, parent = None, name = None):
        TQDataTable.__init__(self, cursor, autoPopulate, parent, name)

    def paintField(self, p, field, cr, b):
        if not field:
            return
        fn = str(field.name())
        if fn in ("salary", "monsalary"):
            v = field.value().toDouble()
            if v < 0:
                p.setPen(TQColor("red"))
            value = TQString("%.2f \u20ac" % v)
            #print unicode(value).encode("iso-8859-15")
            p.drawText(2, 2, cr.width()-6, cr.height()-4,
                        TQt.AlignRight|TQt.AlignVCenter, value)
        elif fn == "statusid":
            query = TQSqlQuery("SELECT name FROM status WHERE id=%s" %
                              field.value().toString())
            value = ""
            if next(query):
                value = query.value(0).toString()
            p.drawText(2, 2, cr.width()-4, cr.height()-4,
                        self.fieldAlignment(field), value)
        else:
            TQDataTable.paintField(self, p, field, cr, b)


class StatusPicker(TQComboBox):
    def __init__(self, parent = None, name = None):
        TQComboBox.__init__(self, parent, name)
        cur = TQSqlCursor("status")
        cur.select(cur.index("id"))
        while next(cur):
            self.insertItem(cur.value("name").toString(), cur.value("id").toInt())


class CustomSqlEditorFactory(TQSqlEditorFactory):
    def __init__(self):
        TQSqlEditorFactory.__init__(self)

    def createEditor(self, parent, field):
        try:
            if str(field.name()) == "statusid":
                return StatusPicker(parent)
        except AttributeError:
            pass
        return TQSqlEditorFactory.createEditor(self, parent, field)


class StaffCursor(TQSqlCursor):
    def __init__(self):
        TQSqlCursor.__init__(self, "staff")
        monSalary = TQSqlFieldInfo("monsalary", TQVariant.Double)
        self.append(monSalary)
        self.setCalculated(monSalary.name(), TRUE)

    def calculateField(self, name):
        if str(name) == "monsalary":
            return TQVariant(self.value("salary").toDouble() / 12)
        return TQVariant(TQString.null)


class Table(CustomTable):
    def __init__(self):
        #self.staffCursor = TQSqlCursor("staff")
        self.staffCursor = StaffCursor()
        TQDataTable.__init__(self, self.staffCursor)
        self.propMap = TQSqlPropertyMap()
        self.editorFactory = CustomSqlEditorFactory()
        self.propMap.insert("StatusPicker", "statusid")
        self.installPropertyMap(self.propMap)
        self.installEditorFactory(self.editorFactory)
        for cn, ch in (("forename", "Forename"),
                       ("surname",  "Surname" ),
                       ("salary",   "Annual Salary"),
                       ("monsalary","Monthly Salary"),
                       ("statusid", "Status")):
            self.addColumn(cn, ch)
        self.order = TQStringList("surname")
        self.order.append("forename")
        self.setSort(self.order)
        self.refresh()


if __name__=='__main__':
    app = TQApplication(sys.argv)
    #app.setFont(TQFont("Verdana", 11))

    if createConnection():
        t = Table()
        app.setMainWidget(t)
        t.resize(600, 250)
        t.show()
        app.exec_loop()


