


from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQ_SIGNAL
from tdeui import KWindowInfo, KPushButton, KTextEdit
from tdecore import i18n, TDEApplication

iconName = 'misc'
labelText = 'KWindowInfo'
helpText = ''


class MainFrame(TQFrame):
    def __init__(self, parent):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Message'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, TQ_SIGNAL('clicked()'), self.showWindowInfo)


    def showWindowInfo(self):
        app = TDEApplication.tdeApplication()
        
        info = KWindowInfo(app.activeWindow())
        info.message('Updated Window Info', 3000)
        
        
