/***************************************************************************
                          commands_file  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright           : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "commands_file.h"
#include <tqstring.h>
#include <kurl.h>
#include <tdemessagebox.h>
//////////////////////////////////////////////////////////////////////////////////////////
///////////		Setting Version & Encoding		//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEVersionEncodingCommand::KXEVersionEncodingCommand(KXEDocument* pDocument, const TQString& oldData, const TQString &newData)
 : KXECommand(pDocument)
{
	m_strOldData = oldData;
	m_strNewData = newData;
}

KXEVersionEncodingCommand::~KXEVersionEncodingCommand()
{
}

void KXEVersionEncodingCommand::execute()
{
	m_pDocument->setSpecProcInstr("xml",m_strNewData);
}

void KXEVersionEncodingCommand::unexecute()
{
	m_pDocument->setSpecProcInstr("xml",m_strOldData);
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Attaching stylesheet			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEStylesheetAttachCommand::KXEStylesheetAttachCommand(KXEDocument* pDocument,const TQString& prevStylesheet,const TQString& newStylesheet)
 : KXECommand(pDocument)
{
	m_strNewStylesheet = newStylesheet;
	m_strPrevStylesheet = prevStylesheet;
}

KXEStylesheetAttachCommand::~KXEStylesheetAttachCommand()
{
}

void KXEStylesheetAttachCommand::execute()
{
	m_pDocument->detachStylesheet();
	m_pDocument->attachStylesheet(KURL(m_strNewStylesheet));
}

void KXEStylesheetAttachCommand::unexecute()
{
	m_pDocument->detachStylesheet();
	if(!m_strPrevStylesheet.isEmpty())
		m_pDocument->attachStylesheet(KURL(m_strPrevStylesheet));
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Detaching Stylesheet		//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEStylesheetDetachCommand::KXEStylesheetDetachCommand(KXEDocument* pDocument,const TQString& prevStylesheet)
 : KXECommand(pDocument)
{
	m_strPrevStylesheet = prevStylesheet;
}

KXEStylesheetDetachCommand::~KXEStylesheetDetachCommand()
{
}

void KXEStylesheetDetachCommand::execute()
{
	m_pDocument->detachStylesheet();
}

void KXEStylesheetDetachCommand::unexecute()
{
  if (!m_strPrevStylesheet.isEmpty())
		m_pDocument->attachStylesheet(KURL(m_strPrevStylesheet));
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Attaching Schema			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXESchemaAttachCommand::KXESchemaAttachCommand(KXEDocument *pDocument,const TQString& newSchema)
 : KXECommand(pDocument)
{
	m_pDocument = pDocument;
	m_strNewSchema = newSchema;
	m_strPrevSchema = "";
}
KXESchemaAttachCommand::KXESchemaAttachCommand(KXEDocument *pDocument,const TQString& newSchema,const TQString& prevSchema)
 : KXECommand(pDocument)
{
	m_strNewSchema = newSchema;
	m_strPrevSchema = prevSchema;
}

KXESchemaAttachCommand::~KXESchemaAttachCommand()
{
}

void KXESchemaAttachCommand::execute()
{
	m_pDocument->detachSchema();						// old schema is removed
	m_pDocument->attachSchema(KURL(m_strNewSchema));		// new schema is applited
}

void KXESchemaAttachCommand::unexecute()
{
	m_pDocument->detachSchema();						// new schema is removed
	if (!m_strPrevSchema.isEmpty())
		m_pDocument->attachSchema(KURL(m_strPrevSchema));		// old schema is applied
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Detaching schema			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXESchemaDetachCommand::KXESchemaDetachCommand(KXEDocument* pDocument, const TQString& schema)
 : KXECommand(pDocument)
{
		m_schema = schema;
}

KXESchemaDetachCommand::~KXESchemaDetachCommand()
{
}

void KXESchemaDetachCommand::execute()
{
	m_pDocument->detachSchema();
}

void KXESchemaDetachCommand::unexecute()
{
	if (!m_schema.isEmpty())
		m_pDocument->attachSchema(KURL(m_schema));
}

