/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "addnetworkroutedialog.h"
#include <tdelocale.h>
#include <tdelistview.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tqcheckbox.h>
#include "widgetnotifyhelper.h"
#include <iostream>

AddNetworkRouteDialog::AddNetworkRouteDialog(TQWidget *parent, const TQString& caption) : KDialogBase( parent, "Add_new_network_route", false, caption,
		KDialogBase::Ok|KDialogBase::Cancel,KDialogBase::Ok, true )
{
	main = new AddNetworkRouteDialogBase (this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());
	connect(main->UseGatewayCheckBox,TQ_SIGNAL(toggled(bool)),this, TQ_SLOT(useGatewayToggled(bool)));
	connect(main->UseInterfaceCheckBox,TQ_SIGNAL(toggled(bool)),this, TQ_SLOT(useInterfaceToggled(bool)));

	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;
	
	Network="";
	Netmask="";
	Gateway="";
	Interface="";
	useGateway=false;
	useInterface=false;
}

AddNetworkRouteDialog::~AddNetworkRouteDialog()
{
	delete main;
}

void AddNetworkRouteDialog::accept()
{
	Network = main->RemoteNetAddrLineEdit->text();
	Netmask = main->RemoteNetMaskComboBox->currentText();
	Gateway = main->RemoteGatewayAddrLineEdit->text();
	Interface = main->InterfaceComboBox->currentText();
	useGateway = main->UseGatewayCheckBox->isChecked();
	useInterface = main->UseInterfaceCheckBox->isChecked();
	TQDialog::accept();
}

TQString AddNetworkRouteDialog::getNetwork()
{
	return Network;
}

TQString AddNetworkRouteDialog::getNetmask()
{
	return Netmask;
}

TQString AddNetworkRouteDialog::getGateway()
{
	return Gateway;
}

TQString AddNetworkRouteDialog::getInterface()
{
	return Interface;
}

bool AddNetworkRouteDialog::getUseGateway()
{
	return useGateway;
}

bool AddNetworkRouteDialog::getUseInterface()
{
	return useInterface;
}

void AddNetworkRouteDialog::useGatewayToggled(bool)
{
	if (main->UseGatewayCheckBox->isChecked())
		main->RemoteGatewayAddrLineEdit->setEnabled(true);
	else
		main->RemoteGatewayAddrLineEdit->setEnabled(false);
}

void AddNetworkRouteDialog::useInterfaceToggled(bool)
{
	if (main->UseInterfaceCheckBox->isChecked())
		main->InterfaceComboBox->setEnabled(true);
	else
		main->InterfaceComboBox->setEnabled(false);
}

void AddNetworkRouteDialog::dialogChanged()
{
// 	std::cout << "AddNetworkRouteDialog::dialogChanged()" << std::endl;
	dialogModified=true;
}

#include "addnetworkroutedialog.moc"
