#ifndef _KVI_KVS_SCRIPTADDONMANAGER_H_
#define _KVI_KVS_SCRIPTADDONMANAGER_H_
//=============================================================================
//
//   File : kvi_kvs_scriptaddonmanager.h
//   Created on Thu 31 Mar 2005 01:21:23 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_heapobject.h"
#include "kvi_qstring.h"
#include "kvi_pointerhashtable.h"


class KviConfig;
class KviKvsScript;
class KviWindow;
class TQPixmap;

class KVIRC_API KviKvsScriptAddon : public KviHeapObject
{
	friend class KviKvsScriptAddonManager;
protected:
	KviKvsScriptAddon();
	KviKvsScriptAddon(
			const TQString &szName,
			const TQString &szVersion,
			const TQString &szVisibleNameCode,
			const TQString &szDescriptionCode,
			const TQString &szUninstallCallbackCode,
			const TQString &szIconId
		);
public:
	KviKvsScriptAddon(const KviKvsScriptAddon &a);
public: // KviDict wants that... how to restrict the deletion to KviKvsScriptAddonManager only ?
	~KviKvsScriptAddon();
protected:
	TQString        m_szName;              // the short name of the addon
	TQString        m_szVersion;           // x.y.z
	KviKvsScript * m_pVisibleNameScript;  // the visible name, possibly translated
	KviKvsScript * m_pDescriptionScript;  // the description, possibly translated
	KviKvsScript * m_pUninstallCallback;  // uninstall callback
	KviKvsScript * m_pConfigureCallback;  // configure callback
	KviKvsScript * m_pHelpCallback;       // help callback
	TQString        m_szDescription;       // parsed description
	TQString        m_szVisibleName;       // parsed visible name
	TQString        m_szIconId;
public:
	const TQString &name() const { return m_szName; };
	const TQString &version() const { return m_szVersion; };
	const TQString &visibleName();
	const TQString &description();
	const TQString &visibleNameCode();
	const TQString &descriptionCode();
	const TQString &uninstallCallbackCode();
	const TQString &configureCallbackCode();
	const TQString &helpCallbackCode();
	const TQString &iconId(){ return m_szIconId; };
	TQPixmap * icon();
	void setConfigureCallback(const TQString &szConfigureCallbackCode);
	void setHelpCallback(const TQString &szHelpCallbackCode);
	void executeConfigureCallback(KviWindow * pWnd);
	void executeHelpCallback(KviWindow * pWnd);
protected:
	bool load(KviConfig * cfg,const TQString &szName);
	void save(KviConfig * cfg);
	void executeUninstallCallback(KviWindow * pWnd);
	// this assumes that the script pointers are clean (i.e. not needing to be freed!)
	void allocateScripts(const TQString &sVisibleNameCode,const TQString &szDescriptionCode,const TQString &szUninstallCallbackCode);
};

class KVIRC_API KviKvsScriptAddonRegistrationData
{
public:
	TQString szName;                      // the addon name
	TQString szVersion;                   // the addon version in form x.y.z
	TQString szVisibleNameScript;         // the code that evaluates to the visible name, possibly translated
	TQString szDescriptionScript;         // the code that evaluates to the description, possibly translated
	TQString szUninstallCallbackScript;   // the uninstall callback code, will be executed at uninstallation
	TQString szIconId;                    // the icon identifier (scaled to 32x32 atm)
};

class KVIRC_API KviKvsScriptAddonManager
{
public:
	KviKvsScriptAddonManager();
	~KviKvsScriptAddonManager();
protected:
	static KviKvsScriptAddonManager  * m_pInstance;
	// this class implements delayed loading
	TQString                            m_szFileName;  // the file name that we will load from
	bool                               m_bLoaded;     // have we loaded stuff from disk yet ?
	KviPointerHashTable<TQString,KviKvsScriptAddon>         * m_pAddonDict;  // all the registered addons
public:
	static KviKvsScriptAddonManager * instance(){ return m_pInstance; };
	static void init(); // called by KviKvs::init()
	static void done(); // called by KviKvs::done()

	bool registerAddon(KviKvsScriptAddonRegistrationData * d);
	KviKvsScriptAddon * findAddon(const TQString &szName);
	bool unregisterAddon(const TQString &szName,KviWindow * pWnd,bool bExecuteUninstallCallback = true);
	KviPointerHashTable<TQString,KviKvsScriptAddon> * addonDict();

	void clear();
	void load(const TQString &szFileName); // called in the KviKvs namespace
	void save(const TQString &szFileName); // called in the KViKvs namespace
protected:
	void delayedLoad();
};

#endif //!_KVI_KVS_SCRIPTADDONMANAGER_H_
