/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef NO_GPSIM

#ifndef DEBUGMANAGER_H
#define DEBUGMANAGER_H

#include <tqguardedptr.h>
#include <tqmap.h>
#include <tqobject.h>

class GpsimProcessor;
class TextDocument;

typedef TQValueList< TQGuardedPtr<GpsimProcessor> > GpsimProcessorList;

/**
@author David Saxton
*/
class DebugManager : public TQObject
{
	TQ_OBJECT
  
	public:
		static DebugManager * self();
		~DebugManager();
		
		void registerGpsim( GpsimProcessor * gpsim );
		/**
		 * Called from TextDocument when it opens a URL so that it can be
		 * connected up to any processors that refer to its url.
		 */
		void urlOpened( TextDocument * td );
		
	protected:
		GpsimProcessorList m_processors;
		
	private:
		DebugManager();
		static DebugManager * m_pSelf;
		
};

#endif

#endif
