/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Richard Lrkng                                                       *
*                                                                         *
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/


#ifndef RECIPEMLIMPORTER_H
#define RECIPEMLIMPORTER_H

#include "baseimporter.h"
#include "datablocks/ingredient.h"
#include "datablocks/recipe.h"

#include <tqdom.h>

/** Class to import the RecipeML, XML-based file format.
  * More info at http://www.formatdata.com/recipeml
  *
  * @author Jason Kivlighn
  */
class RecipeMLImporter : public BaseImporter
{
public:
	RecipeMLImporter();
	virtual ~RecipeMLImporter();

protected:
	void parseFile( const TQString& filename );

private:
	void readRecipemlDirections( const TQDomElement& dirs );
	void readRecipemlHead( const TQDomElement& head );
	void readRecipemlIng( const TQDomElement& ing1, Ingredient *ing2 = 0, const TQString &header = TQString::null );
	void readRecipemlIngs( const TQDomElement& ings );
	void readRecipemlMenu( const TQDomElement& menu );
	void readRecipemlSrcItems( const TQDomElement& sources );
	void readRecipemlRecipe( const TQDomElement& recipe );
	void readRecipemlPreptime( const TQDomElement &preptime );
	void readRecipemlTQty( const TQDomElement &qty, Ingredient &ing );
	void readRecipemlRange( const TQDomElement& range1, double &range2, double &range_offset );

	Recipe recipe;
};

#endif //RECIPEMLIMPORTER_H
