/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RESIZERECIPEDIALOG_H
#define RESIZERECIPEDIALOG_H

#include <kdialogbase.h>

class Recipe;

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class FractionInput;
class TQButtonGroup;
class TQFrame;
class TQLabel;
class KIntNumInput;
class KLineEdit;
class TQRadioButton;
class TQPushButton;

/**
  *@author Jason Kivlighn
  */
class ResizeRecipeDialog : public KDialogBase
{
	TQ_OBJECT

public:
	ResizeRecipeDialog( TQWidget *parent, Recipe* );

protected slots:
	void accept();
	void activateCurrentOption( int );
	virtual void languageChange();

private:
	void resizeRecipe( double factor );

	Recipe *m_recipe;

	TQButtonGroup* buttonGroup;
	TQRadioButton* yieldRadioButton;
	TQFrame* yieldFrame;
	TQLabel* currentYieldLabel;
	TQLabel* newYieldLabel;
	KLineEdit* currentYieldInput;
	FractionInput* newYieldInput;
	TQRadioButton* factorRadioButton;
	TQFrame* factorFrame;
	TQLabel* factorLabel;
	FractionInput* factorInput;

	TQVBoxLayout* buttonGroupLayout;
	TQGridLayout* yieldFrameLayout;
	TQHBoxLayout* factorFrameLayout;
};

#endif //RESIZERECIPEDIALOG_H
