/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/


#ifndef MYSQLRECIPEDB_H
#define MYSQLRECIPEDB_H

#define MYSQL_DRIVER "TQMYSQL3"

#include "qsqlrecipedb.h"

/**
@author Unai Garro
*/
class MySQLRecipeDB : public TQSqlRecipeDB
{

	TQ_OBJECT

private:
	void createDB( void );

public:
	MySQLRecipeDB( const TQString &host, const TQString &user = TQString::null, const TQString &pass = TQString::null, const TQString &DBName = DEFAULT_DB_NAME, int port = 0 );
	~MySQLRecipeDB( void );

	int lastInsertID();

	void createTable( const TQString &tableName );
	void givePermissions( const TQString &dbName, const TQString &username, const TQString &password = TQString::null, const TQString &clientHost = "localhost" );

protected:
	TQString qsqlDriverPlugin() const
	{
		return MYSQL_DRIVER;
	}

private:
	void portOldDatabases( float version );
	TQStringList backupCommand() const;
	TQStringList restoreCommand() const;
};




#endif
