/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006 Eike Hein <hein@kde.org>
*/

#ifndef VIEWTREEITEM_H
#define VIEWTREEITEM_H

#include "chatwindow.h"

#include <tqobject.h>
#include <tqlistview.h>
#include <tqtooltip.h>
#include <tqguardedptr.h>
#include <tqpixmap.h>


class ChatWindow;
class Images;

class ViewTreeItem : public TQListViewItem
{

    public:
        ViewTreeItem(TQListView* parent, const TQString& name, ChatWindow* view);
        ViewTreeItem(TQListViewItem* parent, const TQString& name, ChatWindow* view, int sortIndex = -1);
        ViewTreeItem(TQListViewItem* parent, TQListViewItem* afterItem, const TQString& name, ChatWindow* view);
        // Minimal constructor for separator items.
        explicit ViewTreeItem(TQListView* parent);
        ~ViewTreeItem();

        void setSortIndex(int newSortIndex);
        int getSortIndex() const;

        void setName(const TQString& name);
        TQString getName() const;
        bool isTruncated() const;

        void setView(ChatWindow* view);
        ChatWindow* getView() const;

        ChatWindow::WindowType getViewType() const;
        void setViewType(ChatWindow::WindowType);

        void setColor(TQColor color);
        TQColor getColor() const;

        void setIcon(const TQPixmap& pm);

        void setHighlighted(bool highlight);
        void setCloseButtonShown(bool show);
        void setCloseButtonEnabled();
        bool getCloseButtonEnabled();

        bool sortLast() const;
        bool isSeparator() const;
        int compare(TQListViewItem* i, int col, bool ascending) const;

        void setup();
        void paintFocus(TQPainter* p, const TQColorGroup& cg, const TQRect& r);
        void paintCell(TQPainter* p, const TQColorGroup& cg, int column, int width, int align);

        TQColor mixColor(const TQColor &color1, const TQColor &color2);

    private:
        uint m_sortIndex;
        static int s_availableSortIndex;
        TQGuardedPtr<ChatWindow> m_view;
        ChatWindow::WindowType m_viewType;
        TQColor m_color;

        bool m_isSeparator;
        bool m_isHighlighted;
        bool m_isTruncated;
        bool m_customColorSet;

        Images* images;

        TQPixmap m_closeButton;
        TQPixmap m_disabledCloseButton;
        TQPixmap m_oldPixmap;
        bool m_closeButtonShown;
        bool m_closeButtonEnabled;
};

#endif
