//
// C++ Implementation: komposesystray
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "komposesystray.h"

#include "komposeviewmanager.h"
#include "komposefullscreenwidget.h"
#include "komposesettings.h"
#include "komposeglobal.h"
#include "komposetaskmanager.h"

#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqpainter.h>

#include <tdeapplication.h>
#include <tdeaction.h>
#include <tdepopupmenu.h>
#include <kiconeffect.h>
#include <tdeglobalsettings.h>

KomposeSysTray::KomposeSysTray(TQWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
  // Create Menu
  menu = contextMenu();
  move( -1000, -1000 );
  // Fill Menu
  KomposeGlobal::instance()->getActShowWorldView()->plug(menu);
  KomposeGlobal::instance()->getActShowVirtualDesktopView()->plug(menu);
  KomposeGlobal::instance()->getActShowCurrentDesktopView()->plug(menu);
  menu->insertSeparator();
  KomposeGlobal::instance()->getActPreferencesDialog()->plug(menu);
  KomposeGlobal::instance()->getActConfigGlobalShortcuts()->plug(menu);
  KomposeGlobal::instance()->getActAboutDlg()->plug(menu);

  slotConfigChanged();
  connect( KomposeSettings::instance(), TQ_SIGNAL(settingsChanged()), this, TQ_SLOT(slotConfigChanged()) );
}


KomposeSysTray::~KomposeSysTray()
{}

void KomposeSysTray::slotConfigChanged( )
{
  // set the icon here
  TQPixmap iconPixmap = loadIcon("kompose");
  setPixmap(iconPixmap);
  icon = iconPixmap.convertToImage();
  currentDesktopChanged(KomposeTaskManager::instance()->getCurrentDesktopNum());
}

void KomposeSysTray::mouseReleaseEvent (TQMouseEvent * )
{}

void KomposeSysTray::mousePressEvent ( TQMouseEvent * e )
{
  if ( !rect().contains( e->pos() ) )
    return;

  switch ( e->button() )
  {
  case LeftButton:
    KomposeViewManager::instance()->createView( KomposeSettings::instance()->getDefaultView() );
    break;
  case MidButton:
    // fall through
  case RightButton:
    contextMenuAboutToShow( menu );
    menu->popup( e->globalPos() );
    break;
  default:
    // nothing
    break;
  }
}

void KomposeSysTray::currentDesktopChanged(int desktop)
{
  if (!KomposeSettings::instance()->getShowDesktopNum())
    return;
  // update the icon to display the current desktop number
  // tqDebug("Displaying current desktop number on the tray icon....\n");

  // copying from aKregator/src/trayicon.cpp
  // from KMSystemTray
  int oldW = pixmap()->size().width();
  int oldH = pixmap()->size().height();

  TQString uStr=TQString::number( desktop );
  TQFont f=TDEGlobalSettings::generalFont();
  f.setBold(true);
  f.setItalic(true);
  float pointSize=f.pointSizeFloat();
  TQFontMetrics fm(f);
  int w=fm.width(uStr);
  if( w > (oldW) )
  {
    pointSize *= float(oldW) / float(w);
    f.setPointSizeFloat(pointSize);
  }
  TQPixmap pix(oldW, oldH);
  pix.fill(TQt::white);
  TQPainter p(&pix);
  p.setFont(f);
  p.setPen(TQt::black);
  p.drawText(pix.rect(), TQt::AlignCenter, uStr);
  pix.setMask(pix.createHeuristicMask());
  TQImage img=pix.convertToImage();
  // overlay
  TQImage overlayImg=icon.copy();
  TDEIconEffect::overlay(overlayImg, img);
  TQPixmap newIcon;
  newIcon.convertFromImage(overlayImg);
  setPixmap(newIcon);
}

#include "komposesystray.moc"
