//
// C++ Implementation: komposesettings
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "komposesettings.h"

#include "komposeviewmanager.h"
#include "komposetaskmanager.h"
#include "komposepreferences.h"

#include <tqcolor.h>

#include <tdeglobalaccel.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <kdebug.h>

static KomposeSettings* settingsInstance = 0;


/*
 * KomposeSettings is a singleton
 */
KomposeSettings* KomposeSettings::instance()
{
  if ( !settingsInstance )
  {
    // kdDebug() << "KomposeSettings::instance() - Creating Singleton instance"); // FIXME: How can this apper multiple times??
    settingsInstance = new KomposeSettings();
  }
  return settingsInstance;
}


KomposeSettings::KomposeSettings(TQObject *parent, const char *name)
    : TQObject(parent, name),
    dialogOpen(0),
    windowTitleFontMetrics(0)
{

  // Init global shortcut object
  globalAccel = new TDEGlobalAccel( this );
  globalAccel->insert( "showDefaultView", i18n("Show Komposé (default view)"),
                       i18n("Displays the view you have configured as default"),
                       KKey::QtWIN+Key_Tab, KKey::QtWIN+CTRL+SHIFT+Key_Tab,
                       KomposeViewManager::instance(), TQ_SLOT(createDefaultView()) );
  globalAccel->insert( "showWorldView", i18n("Show Komposé (ungrouped)"),
                       i18n("Displays all windows unsorted"),
                       CTRL+SHIFT+Key_J, KKey::QtWIN+CTRL+SHIFT+Key_J,
                       KomposeViewManager::instance(), TQ_SLOT(createWorldView()) );
  globalAccel->insert( "showVirtualDesktopView", i18n("Show Komposé (grouped by virtual desktops)"),
                       i18n("Displays all windows sorted by virtual desktops"),
                       CTRL+SHIFT+Key_I, KKey::QtWIN+CTRL+SHIFT+Key_I,
                       KomposeViewManager::instance(), TQ_SLOT(createVirtualDesktopView()) );
  globalAccel->insert( "showCurrentDesktopView", i18n("Show Komposé (current virtual desktop)"),
                       i18n("Displays all windows on the current desktop"),
                       CTRL+SHIFT+Key_K, KKey::QtWIN+CTRL+SHIFT+Key_K,
                       KomposeViewManager::instance(), TQ_SLOT(createCurrentDesktopView()) );

  // read Settings from cfg file
  readConfig();

  settingsInstance = this;
}


KomposeSettings::~KomposeSettings()
{
  delete globalAccel;
  delete settingsInstance;
}


void KomposeSettings::readConfig()
{
  kdDebug() << "KomposeSettings::readConfig()" << endl;
  // Read Shortcut Settings from config
  globalAccel->readSettings();
  globalAccel->updateConnections();

  tdeApp->config()->setGroup("Main window");

  defaultView = tdeApp->config()->readNumEntry("defaultView", KOMPOSEDISPLAY_VIRTUALDESKS);

  useComposite = tdeApp->config()->readBoolEntry("useComposite", false);

  passiveScreenshots = tdeApp->config()->readBoolEntry("passiveScreenshots", true);
  screenshotGrabDelay = tdeApp->config()->readNumEntry("screenshotGrabDelay", 400000000);

  // dynamicVirtDeskLayout = tdeApp->config()->readBoolEntry("dynamicVirtDeskLayout", true);

  imageEffects = tdeApp->config()->readBoolEntry("imageEffects", true);
  blurBackground = tdeApp->config()->readBoolEntry("blurBackground", true);

  showIcons = tdeApp->config()->readBoolEntry("showIcons", true);
  iconSize = tdeApp->config()->readNumEntry("iconSize", 3);

  showWindowTitles = tdeApp->config()->readBoolEntry("showWindowTitles", true );
  windowTitleFont = tdeApp->config()->readFontEntry("windowTitleFont", new TQFont( "arial", 11, TQFont::Bold ) );
  windowTitleFontColor = tdeApp->config()->readColorEntry("windowTitleFontColor", new TQColor(TQt::black) );
  showWindowTitleShadow = tdeApp->config()->readBoolEntry("showWindowTitleShadow", true );
  windowTitleFontShadowColor = tdeApp->config()->readColorEntry("windowTitleFontShadowColor", new TQColor(TQt::lightGray) );

  windowBorderActiveColor = tdeApp->config()->readColorEntry("windowBorderActiveColor", new TQColor(TQt::gray) );
  windowBorderInactiveColor = tdeApp->config()->readColorEntry("windowBorderInactiveColor", new TQColor(TQt::black) );
  windowBorderActiveWidth = tdeApp->config()->readNumEntry("windowBorderActiveWidth", 2 );
  windowBorderInactiveWidth = tdeApp->config()->readNumEntry("windowBorderInactiveWidth", 1 );
  windowBorderActiveStyle = tdeApp->config()->readNumEntry("windowBorderActiveStyle", 3 ); // dotted
  windowBorderInactiveStyle = tdeApp->config()->readNumEntry("windowBorderInactiveStyle", 1 ); // solid

  desktopTitleFont = tdeApp->config()->readFontEntry("desktopTitleFont", new TQFont( "arial", 10 ) );
  desktopTitleFontColor = tdeApp->config()->readColorEntry("desktopTitleFontColor", new TQColor(TQt::gray) );
  desktopTitleFontHighlightColor = tdeApp->config()->readColorEntry("desktopTitleFontHighlightColor", new TQColor(TQt::black) );

  cacheScaledPixmaps = tdeApp->config()->readBoolEntry("cacheScaledPixmaps", true);

  activateOnTopLeftCorner = tdeApp->config()->readBoolEntry("activateOnTopLeftCorner", false );
  activateOnTopRightCorner = tdeApp->config()->readBoolEntry("activateOnTopRightCorner", false );
  activateOnBottomLeftCorner = tdeApp->config()->readBoolEntry("activateOnBottomLeftCorner", false );
  activateOnBottomRightCorner = tdeApp->config()->readBoolEntry("activateOnBottomRightCorner", false );

  activateOnTopEdge = tdeApp->config()->readBoolEntry("activateOnTopEdge", false );
  activateOnBottomEdge = tdeApp->config()->readBoolEntry("activateOnBottomEdge", false );
  activateOnLeftEdge = tdeApp->config()->readBoolEntry("activateOnLeftEdge", false );
  activateOnRightEdge = tdeApp->config()->readBoolEntry("activateOnRightEdge", false );

  autoLockDelay = tdeApp->config()->readNumEntry("autoLockDelay", 1000);

  showDesktopNum = tdeApp->config()->readBoolEntry("showDesktopNum", false );

  viewScreen = tdeApp->config()->readNumEntry("viewScreen", -1);

  calcFontMetrics();
  emit settingsChanged();
}

void KomposeSettings::writeConfig()
{
  kdDebug() << "KomposeSettings::writeConfig()" << endl;

  globalAccel->writeSettings();
  globalAccel->updateConnections();

  // Read from config file
  tdeApp->config()->setGroup("Main window");

  tdeApp->config()->writeEntry("defaultView", defaultView );

  tdeApp->config()->writeEntry("useComposite", useComposite );

  tdeApp->config()->writeEntry("passiveScreenshots", passiveScreenshots );
  tdeApp->config()->writeEntry("screenshotGrabDelay", screenshotGrabDelay);

  // tdeApp->config()->writeEntry("dynamicVirtDeskLayout", dynamicVirtDeskLayout);

  tdeApp->config()->writeEntry("imageEffects", imageEffects);
  tdeApp->config()->writeEntry("blurBackground", blurBackground);

  tdeApp->config()->writeEntry("showIcons", showIcons);
  tdeApp->config()->writeEntry("iconSize", iconSize);

  tdeApp->config()->writeEntry("showWindowTitles", showWindowTitles);
  tdeApp->config()->writeEntry("windowTitleFont", windowTitleFont);
  tdeApp->config()->writeEntry("windowTitleFontColor", windowTitleFontColor);
  tdeApp->config()->writeEntry("showWindowTitleShadow", showWindowTitleShadow);
  tdeApp->config()->writeEntry("windowTitleFontShadowColor", windowTitleFontShadowColor);

  tdeApp->config()->writeEntry("windowBorderActiveColor", windowBorderActiveColor);
  tdeApp->config()->writeEntry("windowBorderInactiveColor", windowBorderInactiveColor );
  tdeApp->config()->writeEntry("windowBorderActiveWidth", windowBorderActiveWidth );
  tdeApp->config()->writeEntry("windowBorderInactiveWidth", windowBorderInactiveWidth );
  tdeApp->config()->writeEntry("windowBorderActiveStyle", windowBorderActiveStyle );
  tdeApp->config()->writeEntry("windowBorderInactiveStyle", windowBorderInactiveStyle );

  tdeApp->config()->writeEntry("desktopTitleFont", desktopTitleFont);
  tdeApp->config()->writeEntry("desktopTitleFontColor", desktopTitleFontColor);
  tdeApp->config()->writeEntry("desktopTitleFontHighlightColor", desktopTitleFontHighlightColor);

  tdeApp->config()->writeEntry("cacheScaledPixmaps", cacheScaledPixmaps);

  tdeApp->config()->writeEntry("activateOnTopLeftCorner", activateOnTopLeftCorner);
  tdeApp->config()->writeEntry("activateOnTopRightCorner", activateOnTopRightCorner);
  tdeApp->config()->writeEntry("activateOnBottomLeftCorner", activateOnBottomLeftCorner);
  tdeApp->config()->writeEntry("activateOnBottomRightCorner", activateOnBottomRightCorner);

  tdeApp->config()->writeEntry("activateOnTopEdge", activateOnTopEdge);
  tdeApp->config()->writeEntry("activateOnBottomEdge", activateOnBottomEdge);
  tdeApp->config()->writeEntry("activateOnLeftEdge", activateOnLeftEdge);
  tdeApp->config()->writeEntry("activateOnRightEdge", activateOnRightEdge);
  tdeApp->config()->writeEntry("autoLockDelay", autoLockDelay);

  tdeApp->config()->writeEntry("showDesktopNum", showDesktopNum);

  tdeApp->config()->writeEntry("viewScreen", viewScreen);

  tdeApp->config()->sync();

  kdDebug() << "KomposeSettings::writeConfig() - Settings saved to cfg file" << endl;

  calcFontMetrics();
  emit settingsChanged();
}


void KomposeSettings::showPreferencesDlg()
{
  dialogOpen = true;
  // popup preference dialog
  KomposePreferences *dlg = new KomposePreferences();

  dlg->exec();

  delete dlg;
  dialogOpen = false;
}

int KomposeSettings::getIconSizePixels()
{
  switch( iconSize )
  {
  case 0:
    return 16;
  case 1:
    return 32;
  case 2:
    return 64;
  case 3:
    return -1;
  }
  return 32;
}

void KomposeSettings::calcFontMetrics()
{
  if (windowTitleFontMetrics != 0)
    delete windowTitleFontMetrics;
  windowTitleFontMetrics = new TQFontMetrics( windowTitleFont );
  windowTitleFontAscent = windowTitleFontMetrics->ascent();
  windowTitleFontHeight = windowTitleFontMetrics->height();
}

#include "komposesettings.moc"
