//
// C++ Interface: komposeglobal
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KOMPOSEGLOBAL_H
#define KOMPOSEGLOBAL_H

class KomposeSysTray;

#include <tqobject.h>
#include <tqstring.h>

class TDEPopupMenu;
class TDEActionCollection;
class TDEAction;
class TDESharedPixmap;
class KWinModule;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if defined(TQ_WS_X11) && defined(HAVE_XCOMPOSITE) && defined(HAVE_XDAMAGE) && TQT_VERSION >= 0x030300
# define COMPOSITE
#endif

/**
@author Hans Oischinger
*/
class KomposeGlobal : public TQObject
{
  TQ_OBJECT
protected:
  KomposeGlobal(TQObject *parent = 0, const char *name = 0);

  ~KomposeGlobal();

public:
  static KomposeGlobal *instance();
  KomposeSysTray* getSysTray() { return systray; }
  void initGui();
  
  bool hasAboutDialogOpen() { return aboutDialogOpen; }
  void setHideSystray( bool b ) { hideSystray = b; }
  void setSingleShot( bool b ) { singleShot = b; }
  bool getSingleShot() { return singleShot; }
  bool hasXcomposite() { return xcomposite; }
  int getDamageEvent() { return damageEvent; }
  
  // Action getters
  TDEAction *getActConfigGlobalShortcuts() { return actConfigGlobalShortcuts; }
  TDEAction *getActPreferencesDialog() { return actPreferencesDialog; }
  TDEAction *getActShowVirtualDesktopView() { return actShowVirtualDesktopView; }
  TDEAction *getActShowCurrentDesktopView() { return actShowCurrentDesktopView; }
  TDEAction *getActShowWorldView() { return actShowWorldView; }
  TDEAction *getActAboutDlg() { return actAboutDlg; }
  TDEAction *getActQuit() { return actQuit; }

  const TDESharedPixmap *getDesktopBgPixmap() const { return desktopBgPixmap; }
  
protected:
  void initActions();
  void initImlib();

protected slots:
  void initSharedPixmaps();
  TQString pixmapName(int desk);
  void slotDone(bool success);
  void enablePixmapExports();
  void slotDesktopChanged(int desktop);
  void slotBackgroundChanged(int desktop);
  void refreshSharedPixmaps();
  
  void slotConfigChanged();
  void initCompositeExt();
  void showGlobalShortcutsSettingsDialog();
  void showAboutDlg();

private:
  bool aboutDialogOpen;
  bool hideSystray;
  bool singleShot;
  bool xcomposite;
  int damageEvent, damageError;
  
  TDESharedPixmap *desktopBgPixmap;
  int currentDesktop;
  KomposeSysTray* systray;
  TDEActionCollection* actionCollection;

  TDEAction *actConfigGlobalShortcuts;
  TDEAction *actPreferencesDialog;
  TDEAction *actShowVirtualDesktopView;
  TDEAction *actShowCurrentDesktopView;
  TDEAction *actShowWorldView;
  TDEAction *actAboutDlg;
  TDEAction *actQuit;
  
  KWinModule* twin_module;
};

#endif
