/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KIVIOLAYERPANEL_H
#define KIVIOLAYERPANEL_H

class TDEAction;

class KivioView;
class KivioLayer;

#include <tqlistview.h>

#include "kivio_layer_panel_base.h"

class KivioLayerItem: public TQListViewItem
{
  friend class KivioLayerPanel;
  public:
    KivioLayerItem(TQListView* parent, KivioLayer*, int id);
    ~KivioLayerItem();

    KivioLayer* layer() const { return data; }

  protected:
    void update();

  private:
    KivioLayer* data;
};


/*********************************************************/
class KivioLayerPanel : public KivioLayerPanelBase
{
  TQ_OBJECT
  
  public:
    KivioLayerPanel(KivioView* view, TQWidget* parent=0, const char* name=0);
    ~KivioLayerPanel();

    bool eventFilter(TQObject*, TQEvent*);

  public slots:
    void reset();

  protected slots:
    void addItem();
    void removeItem();
    void renameItem();
    void upItem();
    void downItem();

    void itemClicked(TQListViewItem*, const TQPoint&, int);
    void itemActivated(TQListViewItem*);
    void updateButtons(TQListViewItem*);

  private:
    KivioView* m_pView;

    TDEAction* actNew;
    TDEAction* actDel;
    TDEAction* actRename;
    TDEAction* actUp;
    TDEAction* actDown;

    int id;
};

#endif
