/* This file is part of the KDE project
   Copyright (C) 2003 - 2004 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTPERTCANVAS_H
#define KPTPERTCANVAS_H

#include "kptnode.h"
#include "kptproject.h"

#include <tqcanvas.h>
#include <tqmemarray.h>
#include <tqptrdict.h>

class TQTimer;
class TQPainter;
class TQPoint;
class TQSize;

namespace KPlato
{

class PertNodeItem;

class PertCanvas : public TQCanvasView
{
    TQ_OBJECT
  

public:
    PertCanvas( TQWidget *parent );
    virtual ~PertCanvas();

    void draw(Project& project);
    void clear();
    TQSize canvasSize();

    PertNodeItem *selectedItem();

    int verticalGap() { return m_verticalGap; }
    int horizontalGap() { return m_horizontalGap; }
    TQSize itemSize() { return m_itemSize; }

    void setColumn(int row, int col) { m_rows.at(row)[col] = true; }

    void mapNode(PertNodeItem *item);
    void mapChildNode(PertNodeItem *parentItem, PertNodeItem *childItem, Relation::Type type);
    
    Node *selectedNode();

protected:
    void drawRelations();

    void createChildItems(PertNodeItem *node);
    PertNodeItem *createNodeItem(Node *node);

    void contentsMousePressEvent ( TQMouseEvent * e );
    void contentsMouseReleaseEvent ( TQMouseEvent * e );

signals:
    void rightButtonPressed(Node *node, const TQPoint & point);
    void updateView(bool calculate);
    void addRelation(Node *par, Node *child);
    void modifyRelation(Relation *rel);


private:
    TQCanvas *m_canvas;

    TQTimer *m_scrollTimer;
    bool m_mousePressed;
    bool m_printing;

	int m_verticalGap;
	int m_horizontalGap;
	TQSize m_itemSize;

    TQPtrDict<PertNodeItem> m_nodes;
    TQPtrList<Relation> m_relations;

    TQPtrList<TQMemArray<bool> > m_rows;

#ifndef NDEBUG
    void printDebug( int );
#endif

};

}  //KPlato namespace

#endif
