/* This file is part of the KDE project
   Copyright (C) 2002   Lucijan Busch <lucijan@gmx.at>
   Copyright (C) 2003   Daniel Molkentin <molkentin@kde.org>
   Copyright (C) 2003-2004,2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "kexidatetableedit.h"

#include <tqapplication.h>
#include <tqpainter.h>
#include <tqvariant.h>
#include <tqrect.h>
#include <tqpalette.h>
#include <tqcolor.h>
#include <tqfontmetrics.h>
#include <tqdatetime.h>
#include <tqcursor.h>
#include <tqpoint.h>
#include <tqlayout.h>
#include <tqtoolbutton.h>
#include <tqdatetimeedit.h>
#include <tqclipboard.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kdatepicker.h>
#include <kdatetbl.h>
#include <klineedit.h>
#include <tdepopupmenu.h>
#include <kdatewidget.h>

#include <kexiutils/utils.h>


KexiDateTableEdit::KexiDateTableEdit(KexiTableViewColumn &column, TQWidget *parent)
 : KexiInputTableEdit(column, parent)
{
	setName("KexiDateTableEdit");

//! @todo add TQValidator so date like "2006-59-67" cannot be even entered

	m_lineedit->setInputMask( m_formatter.inputMask() );
}

KexiDateTableEdit::~KexiDateTableEdit()
{
}

void KexiDateTableEdit::setValueInInternalEditor(const TQVariant &value)
{
	if (value.isValid() && value.toDate().isValid()) 
		m_lineedit->setText( m_formatter.dateToString( value.toDate() ) );
	else
		m_lineedit->setText( TQString() );
}

void KexiDateTableEdit::setValueInternal(const TQVariant& add_, bool removeOld)
{
	if (removeOld) {
		//new date entering... just fill the line edit
//! @todo cut string if too long..
		TQString add(add_.toString());
		m_lineedit->setText(add);
		m_lineedit->setCursorPosition(add.length());
		return;
	}
	setValueInInternalEditor( m_origValue );
	m_lineedit->setCursorPosition(0); //ok?
}

void KexiDateTableEdit::setupContents( TQPainter *p, bool focused, const TQVariant& val, 
	TQString &txt, int &align, int &x, int &y_offset, int &w, int &h )
{
	Q_UNUSED(p);
	Q_UNUSED(focused);
	Q_UNUSED(x);
	Q_UNUSED(w);
	Q_UNUSED(h);
#ifdef TQ_WS_WIN
	y_offset = -1;
#else
	y_offset = 0;
#endif
	if (val.toDate().isValid())
		txt = m_formatter.dateToString(val.toDate());
//		txt = val.toDate().toString(TQt::LocalDate);
	align |= AlignLeft;
}

bool KexiDateTableEdit::valueIsNull()
{
//	if (m_lineedit->text().replace(m_formatter.separator(),"").stripWhiteSpace().isEmpty())
	if (m_formatter.isEmpty(m_lineedit->text())) //empty date is null
		return true;
	return dateValue().isNull();
}

bool KexiDateTableEdit::valueIsEmpty()
{
	return valueIsNull();//js OK? TODO (nonsense?)
}

TQDate KexiDateTableEdit::dateValue() const
{
	return m_formatter.stringToDate( m_lineedit->text() );
}

TQVariant KexiDateTableEdit::value()
{
	return m_formatter.stringToVariant( m_lineedit->text() );
}

bool KexiDateTableEdit::valueIsValid()
{
	if (m_formatter.isEmpty(m_lineedit->text())) //empty date is valid
		return true;
	return m_formatter.stringToDate( m_lineedit->text() ).isValid();
}

void KexiDateTableEdit::handleCopyAction(const TQVariant& value, const TQVariant& visibleValue)
{
	Q_UNUSED(visibleValue);
	if (!value.isNull() && value.toDate().isValid())
		tqApp->clipboard()->setText( m_formatter.dateToString(value.toDate()) );
	else
		tqApp->clipboard()->setText( TQString() );
}

void KexiDateTableEdit::handleAction(const TQString& actionName)
{
	const bool alreadyVisible = m_lineedit->isVisible();

	if (actionName=="edit_paste") {
		const TQVariant newValue( m_formatter.stringToDate(tqApp->clipboard()->text()) );
		if (!alreadyVisible) { //paste as the entire text if the cell was not in edit mode
			emit editRequested();
			m_lineedit->clear();
		}
		setValueInInternalEditor( newValue );
	}
	else
		KexiInputTableEdit::handleAction(actionName);
}

/*
void
KexiDateTableEdit::slotDateChanged(TQDate date)
{
	m_edit->setDate(date);
	repaint();
}

void
KexiDateTableEdit::slotShowDatePicker()
{
	TQDate date = m_edit->date();

	m_datePicker->setDate(date);
	m_datePicker->setFocus();
	m_datePicker->show();
	m_datePicker->setFocus();
}

//! @internal helper
void KexiDateTableEdit::moveToFirstSection()
{
	if (!m_dte_date_obj)
		return;
#ifdef TQDateTimeEditor_HACK
	if (m_dte_date)
		m_dte_date->setFocusSection(0);
#else
#ifdef TQ_WS_WIN //tmp
	TQKeyEvent ke_left(TQEvent::KeyPress, TQt::Key_Left, 0, 0);
	for (int i=0; i<8; i++)
		TQApplication::sendEvent( m_dte_date_obj, &ke_left );
#endif
#endif
}

bool KexiDateTableEdit::eventFilter( TQObject *o, TQEvent *e )
{
	if (o==m_datePicker) {
		kdDebug() << e->type() << endl;
		switch (e->type()) {
		case TQEvent::Hide:
			m_datePickerPopupMenu->hide();
			break;
		case TQEvent::KeyPress:
		case TQEvent::KeyRelease: {
			kdDebug() << "ok!" << endl;
			TQKeyEvent *ke = (TQKeyEvent *)e;
			if (ke->key()==Key_Enter || ke->key()==Key_Return) {
				//accepting picker
				acceptDate();
				return true;
			}
			else if (ke->key()==Key_Escape) {
				//canceling picker
				m_datePickerPopupMenu->hide();
				kdDebug() << "reject" << endl;
				return true;
			}
			else m_datePickerPopupMenu->setFocus();
			break;
			}
		default:
			break;
		}
	}
#ifdef TQ_WS_WIN //tmp
	else if (e->type()==TQEvent::FocusIn && o->parent() && o->parent()->parent()==m_edit
		&& m_setNumberOnFocus >= 0 && m_dte_date_obj)
	{
		// there was a number character passed as 'add' parameter in init():
		moveToFirstSection();
		TQKeyEvent ke(TQEvent::KeyPress, int(TQt::Key_0)+m_setNumberOnFocus, 
			'0'+m_setNumberOnFocus, 0, TQString::number(m_setNumberOnFocus));
		TQApplication::sendEvent( m_dte_date_obj, &ke );
		m_setNumberOnFocus = -1;
	}
#endif
#ifdef TQDateTimeEditor_HACK
	else if (e->type()==TQEvent::KeyPress && m_dte_date) {
		TQKeyEvent *ke = static_cast<TQKeyEvent*>(e);
		if ((ke->key()==TQt::Key_Right && !m_sentEvent && cursorAtEnd())
			|| (ke->key()==TQt::Key_Left && !m_sentEvent && cursorAtStart()))
		{
			//the editor should send this key event:
			m_sentEvent = true; //avoid recursion
			TQApplication::sendEvent( this, ke );
			m_sentEvent = false;
			ke->ignore();
			return true;
		}
	}
#endif
	return false;
}

void KexiDateTableEdit::acceptDate()
{
	m_edit->setDate(m_datePicker->date());
	m_datePickerPopupMenu->hide();
	kdDebug() << "accept" << endl;
}

bool KexiDateTableEdit::cursorAtStart()
{
#ifdef TQDateTimeEditor_HACK
	return m_dte_date && m_edit->hasFocus() && m_dte_date->focusSection()==0;
#else
	return false;
#endif
}

bool KexiDateTableEdit::cursorAtEnd()
{
#ifdef TQDateTimeEditor_HACK
	return m_dte_date && m_edit->hasFocus() 
		&& m_dte_date->focusSection()==int(m_dte_date->sectionCount()-1);
#else
	return false;
#endif
}

void KexiDateTableEdit::clear()
{
	m_edit->setDate(TQDate());
}*/

KEXI_CELLEDITOR_FACTORY_ITEM_IMPL(KexiDateEditorFactoryItem, KexiDateTableEdit)

#include "kexidatetableedit.moc"
