/* This file is part of the KDE project
   Copyright (C) 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXI_LLONGVALIDATOR_H
#define KEXI_LLONGVALIDATOR_H

#include "kexiutils_export.h"

#include <tqvalidator.h>
class TQWidget;

namespace KexiUtils {

//! @short A validator for longlong data type.
/*!
  This can be used by TQLineEdit or subclass to provide validated
  text entry.  Can be provided with a base value (default is 10), to allow
  the proper entry of hexadecimal, octal, or any other base numeric data.

  Based on KIntValidator code by Glen Parker <glenebob@nwlink.com>
*/
class KEXIUTILS_EXPORT LongLongValidator : public TQValidator
{
	public:
		LongLongValidator( TQWidget * parent, int base = 10, const char * name = 0 );
		LongLongValidator( TQ_LLONG bottom, TQ_LLONG top, TQWidget * parent, int base = 10, const char * name = 0 );
		virtual ~LongLongValidator();

		//! Validates the text, and returns the result.  Does not modify the parameters.
		virtual State validate( TQString &, int & ) const;

		//! Fixes the text if possible, providing a valid string.  The parameter may be modified.
		virtual void fixup( TQString & ) const;

		//! Sets the minimum and maximum values allowed.
		 virtual void setRange( TQ_LLONG bottom, TQ_LLONG top );

		//! Sets the numeric base value.
		virtual void setBase( int base );

		//! \return the current minimum value allowed
		virtual TQ_LLONG bottom() const;

		//! \return the current maximum value allowed
		virtual TQ_LLONG top() const;

		//! \return the current numeric base
		virtual int base () const;

	private:
		TQ_LLONG m_base;
		TQ_LLONG m_min;
		TQ_LLONG m_max;
};

}
#endif
