#ifndef KDCHARTQSA_H
#define KDCHARTQSA_H
#include <tqsobjectfactory.h>

class KDChartObjectFactory :public TQSObjectFactory {

public:
    KDChartObjectFactory();
    virtual TQObject* create( const TQString& className, const TQSArgumentList& args, TQObject* context );
protected:
    TQObject* createKDChartWidget( const TQSArgumentList& args );
    TQObject* createKDChartTableData( const TQSArgumentList& args );
    TQObject* createTQDateTime( const TQSArgumentList& args );
    TQObject* createTQDate( const TQSArgumentList& args );
    TQObject* createTQTime( const TQSArgumentList& args );
    TQObject* createKDChartTextPiece( const TQSArgumentList& args );
    TQObject* createTQFont( const TQSArgumentList& args );
    TQObject* createKDChartCustomBox( const TQSArgumentList& args );
    TQObject* createTQColor(const TQSArgumentList& args );
    TQObject* createKDChartPropertySet(const TQSArgumentList& args );

    bool isNumber( const TQVariant& );
    bool checkArgCount( const TQString& className, int count, int min, int max );
    bool checkArgsIsTQtClass( const TQSArgumentList& args, int index, const char* expected, const char* constructing );
    bool getString( const TQSArgumentList& arg, int index, TQString* str, const char* constructing  );

    bool getNumber( const TQSArgumentList& args, int index, double* number, const char* constructing );
    bool getNumber( const TQSArgumentList& args, int index, int* number, const char* constructing );
    bool getNumber( const TQSArgumentList& args, int index, uint* number, const char* constructing );

    bool getBool( const TQSArgumentList& arg, int index, bool* b, const char* constructing );
    bool checkIsTQtVariant( const TQSArgumentList& arg, int index, TQVariant::Type expected, const TQString& variantName, const char* constructing );
};


#endif /* KDCHARTQSA_H */

