/***************************************************************************
                          kmymoneytitlelabel.h
                             -------------------
    begin                : Sun Feb 05 2005
    copyright            : (C) 2005 by Ace Jones
    email                : acejones@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTITLELABEL_H
#define KTITLELABEL_H

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqlabel.h>
#include <tqimage.h>
#include <tqcolor.h>
class TQPixmap;

// ----------------------------------------------------------------------------
// TDE Includes

// ----------------------------------------------------------------------------
// Project Includes

/**
  * @author ace jones
  */
class KMyMoneyTitleLabel : public TQLabel
{
  TQ_OBJECT
  
  TQ_PROPERTY( TQString leftImageFile READ leftImageFile WRITE setLeftImageFile DESIGNABLE true )
  TQ_PROPERTY( TQString rightImageFile READ rightImageFile WRITE setRightImageFile DESIGNABLE true )
  TQ_PROPERTY( TQColor bgColor READ bgColor WRITE setBgColor DESIGNABLE true )
  TQ_PROPERTY( TQString text READ text WRITE setText DESIGNABLE true )

public:
  KMyMoneyTitleLabel(TQWidget *parent = 0, const char *name = 0);
  ~KMyMoneyTitleLabel();

  void setBgColor(const TQColor& _color) { m_bgColor = _color; }
  void setLeftImageFile(const TQString& _file);
  void setRightImageFile(const TQString& _file);

  const TQString& leftImageFile(void) const { return m_leftImageFile; }
  const TQString& rightImageFile(void) const { return m_rightImageFile; }
  TQColor bgColor(void) const { return m_bgColor; }
  TQString text(void) const { return m_text; }

public slots:
  virtual void setText(const TQString& txt);

protected:
  void updatePixmap(void);
  virtual void resizeEvent ( TQResizeEvent * );
  void drawContents(TQPainter *);

private:
  TQImage m_leftImage;
  TQImage m_rightImage;
  TQColor m_bgColor;
  TQColor m_textColor;
  TQString m_text;

  TQString m_leftImageFile;
  TQString m_rightImageFile;
};

#endif
