//
// C++ Interface: kmfiptablescompiler
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFIPTABLESCOMPILER_H
#define KMFIPTABLESCOMPILER_H

#include "../../core/kmfcompilerinterface.h"

/**
@author Christian Hubinger
*/

// TQt includes
#include <tqstring.h>
#include <tqobject.h>

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>

// Project includes
#include "../../core/kmfplugin.h"
#include "../../core/kmfcompilerinterface.h"

class TQTabWidget;
class TDEInstance;

namespace KMF {
class KMFListView;
class KMFGenericDoc;
class KMFIPTDoc;
class KMFErrorHandler;

class KMFIPTablesCompiler :  public KMFPlugin, public virtual KMFCompilerInterface {
	TQ_OBJECT
  
public:
	KMFIPTablesCompiler( TQObject* parent, const char* name );
	~KMFIPTablesCompiler();
	void compile();
	const TQString& compile( KMFGenericDoc* );
	const TQString& compile( KMFIPTDoc* );
	const TQString& osName();
	const TQString& osGUIName();
	const TQString& backendName();
	const TQString& backendGUIName();

private slots:
	void slotConvertToIPTDoc();
	void slotExportIPT();
// 	void slotShowIPTScript();

private:
	KMFErrorHandler *m_errorHandler;
	TQTabWidget *m_iptWidget;
	KMFListView *m_iptViewFilter, *m_iptViewNat, *m_iptViewMangle;
	TQString m_osName;
	TQString m_osGUIName;
	TQString m_backendName;
	TQString m_backendGUIName;
	KMFIPTDoc *m_iptdoc;
};




class KMFIPTablesCompilerFactory : public KLibFactory {
	TQ_OBJECT
  
public:
	KMFIPTablesCompilerFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFIPTablesCompilerFactory() {
/* 		delete s_instance; */
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = "TQObject",
	                               const TQStringList &args = TQStringList() );
	/*     static TDEInstance* instance(); */

/*private:
	static TDEInstance* s_instance;*/
};
}


#endif
