//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfaceprotocol.h"

// TQt includes
#include <tqlistview.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqwidgetstack.h>
#include <tqtextedit.h>
#include <tqtimer.h>


// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kcombobox.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfnethost.h"
#include "../core/kmferror.h"

#include "../kmfwidgets/kmflistviewitem.h"
#include "../kmfwidgets/kmfchecklistitem.h"
#include "../kmfwidgets/kmfnetworkwidget.h"
#include "../kmfwidgets/kmfnethostpropertieswidget.h"
#include "../kmfwidgets/kmfprotocolpropertieswidget.h"
#include "../kmfwidgets/kmfprotocollistview.h"

namespace KMF {
KMFGenericInterfaceProtocol::KMFGenericInterfaceProtocol( TQWidget *parent, const char *name, WFlags f ) : KMyFirewallGenericInterfaceProtocolWidget( parent, name, f ) {
	loadIcons();
	m_contextMenu = new TDEPopupMenu( this, "m_contextMenu" );
//	m_lv_protocols->setFullWidth( true );
	
	// Network Widget
	m_network_widget = new KMFNetworkWidget( m_widgetStack, "m_network_widget" );
	m_widgetStack->addWidget( m_network_widget );
	connect( m_network_widget,TQ_SIGNAL( sigZoneChanged( KMFNetZone* ) ),
		this,TQ_SLOT( slotZoneChanged( KMFNetZone* ) ) );
	
	// Host widget
	m_nethostProperties_widget = new KMFNetHostPropertiesWidget( m_widgetStack, "m_nethostProperties_widget" );
	m_widgetStack->addWidget( m_nethostProperties_widget );
	
	connect( m_nethostProperties_widget, TQ_SIGNAL( sigHostAddressChanged( const TQString& ) ),
		this, TQ_SLOT( slotAddressChanged( const TQString& ) ) );
	
	// Protocol Widget
	m_protocolProperties_widget = new KMFProtocolPropertiesWidget( m_widgetStack, "m_protocolProperties_widget" );
	m_widgetStack->addWidget( m_protocolProperties_widget );
	
	
	// Protociol List View
	m_protocolLIstView = new KMFProtocolListView( m_protocolsFrame, "m_protocolLIstView" );
	
	TQGridLayout *grid = new TQGridLayout( m_protocolsFrame, 1, 1 );
	grid->addWidget( m_protocolLIstView, 0, 0 );
	
	connect( m_protocolLIstView,TQ_SIGNAL( sigProtocolClicked( KMFProtocolUsage*, bool ) ),
		this, TQ_SLOT( slotProtocolClicked( KMFProtocolUsage*, bool ) ) );
	
	connect( m_protocolLIstView,TQ_SIGNAL( sigProtocolCategoryClicked( KMFProtocolCategory* ) ),
		this, TQ_SLOT ( slotProtocolCategoryClicked( KMFProtocolCategory* ) ) );
		
	// Zone view
	connect( m_lv_zones, TQ_SIGNAL( pressed( TQListViewItem* ) ) ,
		this, TQ_SLOT( slotNewItemSelected( TQListViewItem* ) ) );
		
	connect( m_lv_zones, TQ_SIGNAL( contextMenuRequested ( TQListViewItem*, const TQPoint&, int ) ),
		this, TQ_SLOT( slotZoneRBM( TQListViewItem*, const TQPoint&, int ) ) );
	
	connect( m_lv_zones, TQ_SIGNAL( itemRenamed ( TQListViewItem *, int, const TQString & ) ) ,
		this, TQ_SLOT( slotRenameItem( TQListViewItem *, int, const TQString & ) ) );
		
	// Main win
	connect( m_c_restrictOutgoing, TQ_SIGNAL( clicked() ),
		this, TQ_SLOT( slotRestrictionChanged() ) );
	
	connect( m_c_allowIncoming, TQ_SIGNAL( clicked() ),
		this, TQ_SLOT( slotRestrictionChanged() ) );
	
	connect( m_zoneSelect, TQ_SIGNAL( activated( const TQString& ) ),
		this, TQ_SLOT( slotCurrentZoneChanged( const TQString& ) ) );	
		
	m_zone = 0;
	m_type = -1;
	m_protocolUsage = 0;
}


KMFGenericInterfaceProtocol::~KMFGenericInterfaceProtocol() {}

void KMFGenericInterfaceProtocol::loadDoc( KMFNetwork *net ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::loadDoc( KMFGenericDoc* doc )" << endl;
	m_doc = net;
	m_doc->currentDocAsGenericDoc()->incomingZone();
	m_zoneSelect->clear();
	m_zoneSelect->insertItem( i18n("Incoming Zone") );
	m_zoneSelect->insertItem( i18n("Outgoing Zone") );
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotUpdateView( NetfilterObject* ) {
	kdDebug() << "KMFGenericInterfaceProtocol::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotUpdateView() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotUpdateView()" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	m_lv_zones->clear();
	m_protocolLIstView->loadProtocols();
	m_protocolLIstView->setEnabled( false );
	
	m_c_allowIncoming->blockSignals( true );
	m_c_restrictOutgoing->blockSignals( true );
	m_c_allowIncoming->setChecked( m_doc->currentDocAsGenericDoc()->allowIncomingConnections() );
	m_c_restrictOutgoing->setChecked( m_doc->currentDocAsGenericDoc()->restrictOutgoingConnections() );
	m_c_allowIncoming->blockSignals( false );
	m_c_restrictOutgoing->blockSignals( false );
	
	TQString zone = m_zoneSelect->currentText();
	if ( zone == i18n("Incoming Zone") ) {
		kdDebug() << "Showing Incoming Zone" << endl;
		KMFListViewItem *item = new KMFListViewItem( m_lv_zones, 0, m_doc->currentDocAsGenericDoc()->incomingZone() );
		item->setupZoneView();
	} else if ( zone == i18n("Outgoing Zone") ) {
		kdDebug() << "Showing Outgoing Zone" << endl;
		KMFListViewItem *item2 = new KMFListViewItem( m_lv_zones, 0, m_doc->currentDocAsGenericDoc()->outgoingZone() );
		item2->setupZoneView();
	}

	if ( ! m_doc->currentDocAsGenericDoc()->allowIncomingConnections() && ! m_doc->currentDocAsGenericDoc()->restrictOutgoingConnections() ) {
		m_lv_zones->setEnabled( false );
		m_protocolLIstView->setEnabled( false );
		m_widgetStack->setEnabled( false );
		return;
	}
	
	m_lv_zones->setEnabled( true );
	// m_protocolLIstView->setEnabled( true );
	m_widgetStack->setEnabled( true );

	if ( m_host ) {
		if ( KMFListViewItem *item = findItem( m_host->uuid() ) ) {
			m_lv_zones->setSelected( item, true );
		}
	} else if ( m_zone ) {
		if ( KMFListViewItem *item = findItem( m_zone->uuid() ) ) {
			m_lv_zones->setSelected( item, true );
		}
	}
	m_lv_zones->setSorting( 0 , false );
}

void KMFGenericInterfaceProtocol::slotRestrictionChanged() {
	m_doc->currentDocAsGenericDoc()->setRestrictOutgoingConnections( m_c_restrictOutgoing->isChecked() );
	m_doc->currentDocAsGenericDoc()->setAllowIncomingConnections( m_c_allowIncoming->isChecked() );
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotCurrentZoneChanged( const TQString& ) {
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotNewItemSelected( TQListViewItem* item ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotNewItemSelected( TQListViewItem* item )" << endl;
	if ( ! item ) {
		m_protocolLIstView->setEnabled( false );
		return ;
	}
	m_protocolUsage = 0;
	m_zone = 0;
	m_host = 0;

	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0 && kmfitem->type() == NetfilterObject::NETZONE ) {
		kdDebug() << "Selected NETZONE" << endl;
		m_widgetStack->raiseWidget( m_network_widget );
		m_zone = kmfitem->zone();
		if ( m_zone ) {
			kdDebug() << "kmfitem->zone() pointer is valid" << endl;
			kmfitem->setText( 0,m_zone->guiName() );
			kmfitem->setText( 1, "[" + m_zone->address()->toString() + i18n("/%1]").arg( m_zone->maskLength() ) );
			m_protocolLIstView->setZone( m_zone );
			m_protocolLIstView->setEnabled( true );
			m_network_widget->loadZone( m_zone );
			
			if ( m_zone->name() == "incoming_world" || m_zone->name() == "outgoing_world" || m_zone->readOnly() ) {
				m_network_widget->allowEdit( false );
			} else {
				m_network_widget->allowEdit( true );
			}
			 
		} 
	} else if ( kmfitem != 0 && kmfitem->type() == NetfilterObject::NETHOST ) {
		kdDebug() << "Selected NETHOST" << endl;
		m_widgetStack->raiseWidget( m_nethostProperties_widget );
		m_host = kmfitem->host();
		m_zone = m_host->zone();
		if ( m_host ) {
			kdDebug() << "kmfitem->host() pointer is valid" << endl;
			m_nethostProperties_widget->loadHost( m_host );
			m_protocolLIstView->setEnabled( true );
			m_protocolLIstView->setHost( m_host );
		} 
	} else {
		m_protocolLIstView->setEnabled( false );
	}
	kdDebug() << "Laving slotNewItemSelected()" << endl;
}

void KMFGenericInterfaceProtocol::slotZoneRBM( TQListViewItem* item, const TQPoint& point, int ) {
	if ( ! item )
		return ;
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0  && kmfitem->type() == NetfilterObject::NETZONE ) {
		kdDebug() << "Setting up Zone RBM:" << endl;
		m_host = 0;
		m_zone = 0;
		m_zone = kmfitem->zone();
		if ( m_zone ) {
			m_contextMenu->clear();
			TQString name = m_zone->name();
			TQString lab_str = i18n("Zone: %1").arg( m_zone->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_new, i18n( "Add Host..." ), this, TQ_SLOT( slotAddHost() ) );

			
				m_contextMenu->insertSeparator();
				m_contextMenu->insertItem( icon_new, i18n( "Add Zone..." ), this, TQ_SLOT( slotAddZone() ) );
			if ( m_zone->name() != "incoming_world" && m_zone->name() != "outgoing_world" ) {
				m_contextMenu->insertItem( icon_rename, i18n( "Rename Zone..." ), this, TQ_SLOT( slotRenameZone() ) );
				m_contextMenu->insertSeparator();
				m_contextMenu->insertItem( icon_del, i18n( "Delete Zone" ), this, TQ_SLOT( slotDelZone() ) );
			}

			m_contextMenu->popup( point );
		}
	} else if ( kmfitem != 0  && kmfitem->type() == NetfilterObject::NETHOST ) {
		kdDebug() << "Setting up Host RBM:" << endl;
		m_host = 0;
		m_host = kmfitem->host();
		if ( m_host ) {
			m_contextMenu->clear();
			TQString name = m_host->name();
			TQString lab_str = i18n("Host: %1").arg( m_host->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_rename, i18n( "Rename Host..." ), this, TQ_SLOT( slotRenameHost() ) );
			m_contextMenu->insertItem( icon_rename, i18n( "Delete Host..." ), this, TQ_SLOT( slotDelHost() ) );
			m_contextMenu->popup( point );
		}
	}
}

void KMFGenericInterfaceProtocol::slotProtocolClicked( KMFProtocolUsage* protUsage, bool onOff ) {
	kdDebug() << " KMFGenericInterfaceProtocol::slotProtocolClicked( KMFProtocolUsage* protUsage, bool onOff )" << endl;
	if ( ! protUsage || ! m_zone ) {
		kdDebug() << "WARNING: no protUsage selected" << endl;
		return ;
	}
	m_widgetStack->raiseWidget( m_protocolProperties_widget );
	if ( m_zone && ! m_host ) {
		if ( onOff ) {
			m_protocolUsage = 0;
			KMFProtocolUsage* pro;
			if ( pro = m_zone->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				m_protocolUsage = pro;
			} else { 
					KMFUndoEngine::instance()->startTransaction(
					m_zone,
					i18n("Add protocol %1 to zone %2.").arg( protUsage->protocol()->name() ).arg( m_zone->guiName() )
					);
					pro = m_zone->addProtocolUsage( protUsage->protocol()->uuid(), protUsage->protocol()->getDOMTree() );
			
				if ( pro ) {
					kdDebug() << "Added Protocol to zone: " << m_zone-> name()  << endl;
					m_protocolUsage = pro;
					KMFUndoEngine::instance()->endTransaction();
				} else {
					KMFUndoEngine::instance()->abortTransaction();
				}
			} 
			
			if ( m_protocolUsage ) {
				m_protocolProperties_widget->loadProtocolUsage( m_protocolUsage );
			} 
		} else {
			m_protocolProperties_widget->loadProtocol( protUsage->protocol() );
			if ( m_zone->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				KMFUndoEngine::instance()->startTransaction(
					m_zone,
					i18n("Delete protocol %1 from zone %2.").arg( protUsage->protocol()->name() ).arg( m_zone->guiName() )
				);
				m_zone->delProtocolUsage( protUsage );
				KMFUndoEngine::instance()->endTransaction();
			}
		}

	} else if ( m_host ) {
		if ( onOff ) {
			m_protocolUsage = 0;
			KMFProtocolUsage* pro;
			
				if ( pro = m_host->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				m_protocolUsage = pro;
			} else {
				KMFUndoEngine::instance()->startTransaction(
					m_host,
					i18n("Add protocol %1 to host %2.").arg( protUsage->protocol()->name() ).arg( m_host->guiName() )
					);
					pro = m_host->addProtocolUsage( protUsage->protocol()->uuid(), protUsage->protocol() ->getDOMTree() );
			
				if ( pro ) {
					kdDebug() << "Added Protocol to host: " << m_host-> name()  << endl;
					m_protocolUsage = pro;
					KMFUndoEngine::instance()->endTransaction();
				} else {
					KMFUndoEngine::instance()->abortTransaction();
				}
			} 
			if ( m_protocolUsage ) {
				m_protocolProperties_widget->loadProtocolUsage( m_protocolUsage );
			} 
		} else {
			m_protocolProperties_widget->loadProtocol( protUsage->protocol() );
			if ( m_host->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				KMFUndoEngine::instance()->startTransaction(
					m_host,
					i18n("Delete protocol %1 from host %2.").arg( protUsage->protocol()->name() ).arg( m_host->guiName() )
				);
				m_host->delProtocolUsage( protUsage );
				KMFUndoEngine::instance()->endTransaction();
			}
		}
	}
}

void KMFGenericInterfaceProtocol::slotProtocolCategoryClicked( KMFProtocolCategory* protCat ) {
	kdDebug() << " KMFGenericInterfaceProtocol::slotProtocolCategoryClicked( KMFProtocolUsage* protUsage, bool onOff )" << endl;
	if ( ! protCat )  {
		return;
	}
	
	m_widgetStack->raiseWidget( m_protocolProperties_widget );
	m_protocolProperties_widget->loadProtocolCategory( protCat );
}




void KMFGenericInterfaceProtocol::slotAddZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddZone()" << endl;
	bool ok;
	TQString name = KInputDialog::getText(i18n("New Zone"), i18n("Zone Name"),i18n("NewZone"), &ok, this );
	if ( !ok )
		return;
	
	
	if ( m_zoneSelect->currentText() == i18n("Incoming Zone") ) {
		TQString s = "";
		s = s.setNum( m_doc->currentDocAsGenericDoc()->incomingZone()->zones().count() );
		KMFUndoEngine::instance()->startTransaction(
			m_doc->currentDocAsGenericDoc()->incomingZone(),
			i18n("Add Zone %1 to Incoming Zone").arg( name )
		);
		KMFNetZone * zone = m_doc->currentDocAsGenericDoc()->incomingZone()->addZone( "" + m_doc->currentDocAsGenericDoc()->incomingZone()->name() + "_z_" + s,  new KMFError() );
		if ( zone ) {
			zone->setGuiName( name );
			m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
		
	} else if ( m_zoneSelect->currentText() == i18n("Outgoing Zone") ) {
		TQString s = "";
		s = s.setNum( m_doc->currentDocAsGenericDoc()->outgoingZone()->zones().count() );
		KMFUndoEngine::instance()->startTransaction(
			m_doc->currentDocAsGenericDoc()->outgoingZone(),
			i18n("Add Zone %1 to Outgoing Zone.").arg( name )
		);
		
		KMFNetZone * zone = m_doc->currentDocAsGenericDoc()->outgoingZone()->addZone( "" + m_doc->currentDocAsGenericDoc()->outgoingZone()->name() + "_z_" + s,  new KMFError() );
		if ( zone ) {
			zone->setGuiName( name );
			m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
	}
	
	
}

void KMFGenericInterfaceProtocol::slotDelZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotDelZone()" << endl;
	if ( ! m_zone )
		return;
	if ( m_zone->name() != "incoming_world" || m_zone->name() != "outgoing_world" ) {
		KMFUndoEngine::instance()->startTransaction(
			m_zone->zone(),
			i18n("Delete zone %1 from zone %2.").arg( m_zone->guiName() ).arg( m_zone->zone()->guiName() )
		);
		m_zone->zone()->delZone( m_zone );
		m_zone = 0;
		m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
		m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
		KMFUndoEngine::instance()->endTransaction();
		slotUpdateView();
	}
}

void KMFGenericInterfaceProtocol::slotAddHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddHost()" << endl;
	bool ok;
	TQString name = KInputDialog::getText( i18n("New Host"), i18n("Host Name"),i18n("New Host"), &ok, this );
	if ( !ok )
		return;
	
	if ( m_zone ) {
		TQString s = "";
		s = s.setNum( m_zone->hosts().count() );
		KMFUndoEngine::instance()->startTransaction( 
			m_zone,
			i18n("Add Host %1 to Zone: %2").arg( name ).arg( m_zone->guiName() )  
		);
		KMFNetHost * host = m_zone->addNetHost( "" + m_zone->name() + "_h_" + s,  * (new TQDomDocument() ) );
		if ( host ) {
			host->setGuiName( name );
			KMFUndoEngine::instance()->endTransaction();			m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
			m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
	}
}

void KMFGenericInterfaceProtocol::slotDelHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotDelHost()" << endl;
	if ( ! m_zone || ! m_host )
		return;
	KMFUndoEngine::instance()->startTransaction( 
		m_zone,
		i18n("Delete host %1 from zone: %2").arg( m_host->guiName() ).arg( m_zone->guiName() )  
	);
	m_zone->delHost( m_host );
	m_host = 0;
	m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
	m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
	KMFUndoEngine::instance()->endTransaction();
	slotUpdateView();
}

KMFListViewItem* KMFGenericInterfaceProtocol::findItem( const TQUuid& obj_id ) {
	kdDebug() << "KMFListViewItem* KMFGenericInterfaceProtocol::findItem( int obj_id )" << endl;
	TQListViewItem* root = m_lv_zones->firstChild();
	if ( ! root )
		return 0;
	TQListViewItem* item = root->firstChild();
	while ( item ) {
// 		item->setText( 0, item->text(0) +"_searched" );
		if ( KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item ) ) {
			kdDebug() << "kmfitem->uuid(): " << kmfitem->uuid() <<
				" obj_id: " << obj_id << endl;
			
			if ( kmfitem->uuid() == obj_id ) {
				kdDebug() << "MATCHED" << endl;
				return kmfitem;
			}
		}
		item = item->itemBelow();
	}
	return 0;
}

// void KMFGenericInterfaceProtocol::slotAddressChanged( int, int, int, int ) {
// 
// 
// 
// }

void KMFGenericInterfaceProtocol::slotAddressChanged( const TQString& ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddressChanged( const TQString& )" << endl;
	if ( ! m_host ) {
		return;
	}
	slotUpdateView();
	if ( KMFListViewItem *item = findItem( m_host->uuid() ) ) {
		item->setText( 1, "[" + m_host->address()->toString() + "]" );
	}
}

void KMFGenericInterfaceProtocol::slotZoneChanged( KMFNetZone* z ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotZoneChanged( KMFNetZone* z )" << endl;
	if ( KMFListViewItem *item = findItem( z->uuid() ) ) {
		kdDebug() << "Updating item" << endl;
				item->setText( 1, "[" + z->address()->toString() + i18n("/%1]").arg( z->maskLength() ) );	
	}
	m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
	m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
	slotUpdateView();
	
}


void KMFGenericInterfaceProtocol::slotRenameZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameZone()" << endl;
	if ( ! m_zone )
		return;
	if ( KMFListViewItem* item = findItem( m_zone->uuid() ) ) {
		item->setRenameEnabled( 0 ,true );
		item->startRename(0);
	}
}

void KMFGenericInterfaceProtocol::slotRenameHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameHost()" << endl;
	if ( ! m_host )
		return;
	if ( KMFListViewItem* item = findItem( m_host->uuid() ) ) {
		item->setRenameEnabled( 0 ,true );
		item->startRename(0);
	}
}

void KMFGenericInterfaceProtocol::slotRenameItem( TQListViewItem* item, int, const TQString& name ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameItem( TQListViewItem* item, int, const TQString& name )" << endl;
	if ( ! item )
		return;

	if ( name.isEmpty() ) {
		slotUpdateView();
		return;
	}

	if ( KMFListViewItem *kmfitem = dynamic_cast<KMFListViewItem*> (item) ) {
		if ( kmfitem->type() == NetfilterObject::NETZONE ) {
			KMFUndoEngine::instance()->startTransaction( 
				kmfitem->zone(),
				i18n("Rename zone %1 to %2.").arg( kmfitem->zone()->guiName() ).arg( name )  
			);
			
			kmfitem->zone()->setGuiName( name );
			kdDebug() << "Renaming Zone: " << kmfitem->zone()->name() << endl;
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
			return;
		}
	}
	
	if ( KMFListViewItem *kmfitem = dynamic_cast<KMFListViewItem*> (item) ) {
		if ( kmfitem->type() == NetfilterObject::NETHOST ) {
			KMFUndoEngine::instance()->startTransaction( 
				kmfitem->host(),
				i18n("Rename host %1 to %2.").arg( kmfitem->host()->guiName() ).arg( name )  
			);
			kmfitem->host()->setGuiName( name );
			kdDebug() << "Renaming Host: " << kmfitem->host()->name() << endl;
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
			return;
		}
	}
	
}
 
void KMFGenericInterfaceProtocol::loadIcons() {
	kdDebug() << "void KMFGenericInterfa::loadIcons()" << endl;
	TDEIconLoader *loader = TDEGlobal:: iconLoader();
	TQString icon_name;

	icon_name = "go-up";
	icon_up = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "go-down";
	icon_down = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "edit-delete";
	icon_del = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "document-new";
	icon_new = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, TDEIcon::Small );


	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "text";
	icon_rename = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "rule-22";
	icon_rule = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, TDEIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, TDEIcon::User );

	icon_name = "process-stop";
	icon_drop = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "document-save-as";
	icon_log = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "edit-undo";
	icon_return = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "edit-clear";
	icon_cmd = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "edit-copy";
	icon_copy = loader->loadIcon( icon_name, TDEIcon::Small );

	icon_name = "forward";
	icon_move = loader->loadIcon( icon_name, TDEIcon::Small );

}

}
#include "kmfgenericinterfaceprotocol.moc"
