/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTARGETCONFIG_H
#define KMFTARGETCONFIG_H


// TQt includes
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqdom.h>
#include <tqobject.h>


#include <tqstring.h>

// KDE includes
#include <tdemacros.h>
#include <kurl.h>

// Project includes
#include "netfilterobject.h"

namespace KMF {
class KMFTarget;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
 */

class TDE_EXPORT KMFTargetConfig : public NetfilterObject {
	public: 
		KMFTargetConfig( KMFTarget* target, const char* name );
	
	virtual ~KMFTargetConfig();
		
	virtual int type();
	virtual void clear();
	
	virtual const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	/**
	Get the target object for this configuration
	*/
	KMFTarget* target() const {
		return m_target;
	}
	
	/**
	Set Which OS are we using.
	*/
	void setOS( const TQString & v );

	/**
	Get Which OS are we using.
	*/
	const TQString& oS() const {
		return m_OS;
	}

	/**
	Set Firewalling backend name.
	*/
	void setBackend( const TQString & );

	/**
	Get Firewalling backend name.
	*/
	const TQString& backend() const {
		return m_Backend;
	}


	/**
	Set What kind of ditribution are we using.
	*/
	void setDistribution( const TQString & v );

	/**
	Get What kind of ditribution are we using.
	*/
	const TQString& distribution() const {
		return m_Distribution;
	}

	/**
	Set Path to the init scripts
	*/
	void setInitPath( const TQString & v );

	/**
	Get Path to the init scripts
	*/
	const TQString& initPath() const {
		return m_InitPath;
	}

	/**
	Set Path to the default runlevel directory.
	*/
	void setRcDefaultPath( const TQString & v );

	/**
	Get Path to the default runlevel directory.
	*/
	const TQString& rcDefaultPath() const {
		return m_RcDefaultPath;
	}

	/**
	Set Path to iptables binary.
	*/
	void setIPTPath( const TQString & v );

	/**
	Get Path to iptables binary.
	*/
	const TQString& IPTPath() const {
		return m_IPTPath;
	}

	/**
	Set Path to the modprobe binary.
	*/
	void setModprobePath( const TQString & v );

	/**
	Get Path to the modprobe binary.
	*/
	const TQString& modprobePath() const {
		return m_ModprobePath;
	}
	


	/**
	Set Network interfaces
	*/
	void setInterfaces( const TQStringList & v );

	/**
	Get Network interfaces
	*/
	TQStringList& interfaces() {
		return m_Interfaces;
	}
	
	/** 
	Get Indicator if the config is valid
	*/
	bool isValid() const;
	
	TQString toString();

private:
	KMFTarget* m_target;
	
	TQString m_targetName;
	KURL m_configFile;
	
	// GENERAL
	TQString m_OS;
	TQString m_Backend;

	// PATHS
	TQString m_Distribution;
	TQString m_InitPath;
	TQString m_RcDefaultPath;
	TQString m_IPTPath;
	TQString m_ModprobePath;
	TQString m_CurrentGenericConfiguration;
	TQString m_CurrentIPTConfiguration;

	// INTERFACES
	TQStringList m_Interfaces;
};
}
#endif
