/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "welcome.h"
#include "version.h"

#include <tdelocale.h>

#include <tdestandarddirs.h>

#include <tqlayout.h>
#include <tdehtml_part.h>
#include <tqfile.h>

Aboutklamav::Aboutklamav(TQWidget *parent, const char *name)
    : TQWidget(parent, name)
{
	TQVBoxLayout *vbox = new TQVBoxLayout(this, KDialog::marginHint(),
			KDialog::spacingHint(), "vbox");

	TQWidget* privateLayoutWidget = new TQWidget( this, "dblayout" );
	vbox->addWidget(privateLayoutWidget);

	TQGridLayout* dblayout = new TQGridLayout( privateLayoutWidget, 1, 1, 2, 2, "dblayout"); 
	dblayout->setColStretch(1, 1);

	htmlpart = new TDEHTMLPart(privateLayoutWidget);
	dblayout->addMultiCellWidget( htmlpart->widget(), 0, 1, 1, 1 );

	TQString location = locate("data", "klamav/about/aboutklamav.html");
	TQString res = loadFile(location);

	/* Stylesheets */
	res = res.arg( locate( "data", "klamav/about/klamav.css" ) );
	res = res.arg( locate( "data", "tdeui/about/kde_infopage.css" ) );
	if ( tdeApp->reverseLayout() )
		res = res.arg( "@import \"%1\";" ).arg( locate( "data", "tdeui/about/kde_infopage_rtl.css" ) );
	else
		res = res.arg( "" );


	res = res.arg("KlamAV")
		.arg("KlamAV")
		.arg( i18n("Version ")+TQString(KLAMAV_VERSION) )
		.arg( i18n("An anti-virus manager for the Trinity Desktop Environment") )
		.arg( i18n("KlamAV is a convenient way to manage ClamAV. KlamAV provides:") )
		.arg( i18n("Scheduled scanning") )
		.arg( i18n("Automatic virus database updates") )
		.arg( i18n("E-Mail scanning") )
		.arg( i18n("Virus information browser") )
		.arg( i18n("Quarantine management") )
		.arg( i18n("This program is a front-end for") );
	
	htmlpart->begin();
	htmlpart->write(res);
	htmlpart->end();
}


Aboutklamav::~Aboutklamav()
{
}

/* borrowed from Konqueror */
TQString Aboutklamav::loadFile( const TQString& file ) {
	TQString res;
	if( file.isEmpty() )
		return res;

	TQFile f(file);

	if( !f.open(IO_ReadOnly) )
    		return res;

	TQTextStream t(&f);
	res = t.read();

	return res;
}

#include "welcome.moc"





