/* ============================================================
 * File  : gpcommand.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-22
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPCOMMAND_H
#define GPCOMMAND_H

#include <tqstring.h>

namespace KIPIKameraKlientPlugin
{

class GPCommand {
public:
    enum Type {
        Init=0,
        GetSubFolders,
        MakeFolder,
        DeleteFolder,
        GetItemsInfo,
        GetAllItemsInfo,
        GetThumbnail,
        DownloadItem,
        DeleteItem,
        DeleteAllItems,
        OpenItem,
        OpenItemWithService,
        UploadItem,
        ExifInfo
    };    
    GPCommand(Type type) : type_(type) {
    }
    Type type() const {
		return type_;
    }

private:
    Type type_;
};

class GPCommandGetSubFolders : public GPCommand {
public:
    GPCommandGetSubFolders(const TQString& folder) : GPCommand(GetSubFolders), folder_(folder) {
    }
    TQString folder() const {
	return folder_;
    }
private:
    TQString folder_;
};

class GPCommandMakeFolder : public GPCommand {
public:
    GPCommandMakeFolder(const TQString& folder, const TQString& newFolder)
	: GPCommand(MakeFolder), folder_(folder), newFolder_(newFolder) {
    }
    TQString folder() const {
		return folder_;
    }
    TQString newFolder() const {
		return newFolder_;
    }
private:
    TQString folder_;
    TQString newFolder_;
};

class GPCommandDeleteFolder : public GPCommand {
public:
    GPCommandDeleteFolder(const TQString& folder) : GPCommand(DeleteFolder), folder_(folder) {
    }
    TQString folder() const {
		return folder_;
	}
private:
    TQString folder_;
};

class GPCommandGetItemsInfo : public GPCommand {
public:
    GPCommandGetItemsInfo(const TQString& folder) : GPCommand(GetItemsInfo), folder_(folder) {
    }
    TQString folder() const {
	return folder_;
    }
private:
    TQString folder_;
};

class GPCommandGetAllItemsInfo : public GPCommand {
public:
    GPCommandGetAllItemsInfo(const TQString& folder) : GPCommand(GetAllItemsInfo), folder_(folder) {
    }
    TQString folder() const {
		return folder_;
    }
private:
    TQString folder_;
};

class GPCommandGetThumbnail : public GPCommand {
public:
    GPCommandGetThumbnail(const TQString& folder, const TQString& imageName)
	: GPCommand(GetThumbnail), folder_(folder), imageName_(imageName) {
    }
    TQString folder() const {
	return folder_;
    }
    TQString imageName() const {
	return imageName_;
    }

private:
    TQString folder_;
    TQString imageName_;
};

class GPCommandDownloadItem : public GPCommand {
public:
    GPCommandDownloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile) : GPCommand(DownloadItem), folder_(folder), itemName_(itemName), saveFile_(saveFile) {
    }
    TQString folder() const {
		return folder_;
    }
    TQString itemName() const {
		return itemName_;
    }
    TQString saveFile() const {
		return saveFile_;
    }
private:
    TQString folder_;
    TQString itemName_;
    TQString saveFile_;
};

class GPCommandDeleteItem : public GPCommand {
public:
    GPCommandDeleteItem(const TQString& folder, const TQString& itemName) : GPCommand(DeleteItem), folder_(folder), itemName_(itemName) {
    }
    TQString folder() const {
		return folder_;
    }
    TQString itemName() const {
		return itemName_;
    }
private:
    TQString folder_;
    TQString itemName_;
};

class GPCommandDeleteAllItems : public GPCommand {
public:
    GPCommandDeleteAllItems(const TQString& rootFolder) : GPCommand(DeleteAllItems), folder_(rootFolder) {
    }
    TQString rootFolder() const {
		return folder_;
	}
private:
    TQString folder_;
};

class GPCommandUploadItem : public GPCommand {
public:
    GPCommandUploadItem(const TQString& folder, const TQString& localFile, const TQString& uploadName) : GPCommand(UploadItem), folder_(folder), localFile_(localFile), uploadName_(uploadName) {
    }
    TQString folder() const {
		return folder_;
    }
    TQString localFile() const {
		return localFile_;
    }
    TQString uploadName() const {
		return uploadName_;
    }
private:
    TQString folder_;
    TQString localFile_;
    TQString uploadName_;
};

class GPCommandOpenItem : public GPCommand {
public:
    GPCommandOpenItem(const TQString& folder, const TQString& itemName, const TQString& saveFile) : GPCommand(OpenItem), folder_(folder), itemName_(itemName), saveFile_(saveFile) {
    }
    TQString folder() const {
	return folder_;
    }
    TQString itemName() const {
	return itemName_;
    }
    TQString saveFile() const {
	return saveFile_;
    }
private:
    TQString folder_;
    TQString itemName_;
    TQString saveFile_;
};

class GPCommandOpenItemWithService : public GPCommand {
public:
    GPCommandOpenItemWithService(const TQString& folder, const TQString& itemName, const TQString& saveFile, const TQString& serviceName) : GPCommand(OpenItemWithService), folder_(folder), itemName_(itemName), saveFile_(saveFile), serviceName_(serviceName) {
    }
    TQString folder() const {
		return folder_;
    }
    TQString itemName() const {
		return itemName_;
    }
    TQString saveFile() const {
		return saveFile_;
    }
    TQString serviceName() const {
		return serviceName_;
    }
private:
    TQString folder_;
    TQString itemName_;
    TQString saveFile_;
    TQString serviceName_;
};

class GPCommandExifInfo : public GPCommand {
public:
    GPCommandExifInfo(const TQString& folder, const TQString& itemName) : GPCommand(ExifInfo), folder_(folder), itemName_(itemName) {
	}
    TQString folder() const {
		return folder_;
	}
    TQString itemName() const {
		return itemName_;
	}
private:
    TQString folder_;
    TQString itemName_;
};

}  // NameSpace KIPIKameraKlientPlugin

#endif /* GPCOMMAND_H */

