/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGELISTITEM_H
#define IMAGELISTITEM_H

#include <gpod/itdb.h>

#include <tqstring.h>
#include <tdelistview.h>
#include <tdelocale.h>

namespace IpodExport
{

    class ImageListItem : public TDEListViewItem
    {
    public:

        ImageListItem( TQListView *parent, TQString const & pathSrc, TQString const & name )
            : TDEListViewItem( parent, TQString()/*set below*/, name )
            , m_pathSrc( pathSrc )
        {
            setText( 0, pathSrc.section('/', -2, -2) );
        }

        TQString          pathSrc()    const { return m_pathSrc;    }

    private:
        TQString          m_pathSrc;
    };

}

#endif  // IMAGELISTITEM_H
