//////////////////////////////////////////////////////////////////////////////
//
//    CDARCHIVING.H
//
//    Copyright (C) 2003-2004 Gilles Caulier <caulier dot gilles at gmail dot com>
//    Copyright (C) 2003-2004 by Gregory Kokanosky <gregory dot kokanosky at free.fr>
//    for images navigation mode.
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef CDARCHIVING_H
#define CDARCHIVING_H

// C Ansi includes.

extern "C"
{
#include <unistd.h>
}

// TQt includes

#include <tqcolor.h>
#include <tqdatetime.h>
#include <tqdir.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

// KDE includes

#include <tdeaction.h>
#include <kurl.h>

// KIPI includes

#include <libkipi/imagecollection.h>
#include <libkipi/interface.h>

class TDEProcess;

namespace KIPICDArchivingPlugin
{

class CDArchivingDialog;

const int NAV_THUMB_MAX_SIZE = 64;

// First field is the URL, represented with KURL::prettyURL. We can't use KURL
// directly because operator<(KURL,KURL) is not defined in KDE 3.1

class CDArchiving : public TQObject
{
    TQ_OBJECT
  

public:

    CDArchiving( KIPI::Interface* interface, TQObject *parent=0,
                 TDEAction *action_cdarchiving=0 );
    ~CDArchiving();

    bool prepare(void);
    bool showDialog();

    void invokeK3b();
    void removeTmpFiles(void);

    void run(void);
    void stop(void);


public slots:

    void slotK3bDone(TDEProcess*);
    void slotK3bStartBurningProcess(void);

private:

    CDArchivingDialog  *m_configDlg;

    TDEAction            *m_actionCDArchiving;

    KIPI::Interface    *m_interface;

    TDEProcess           *m_Proc;

    KURL                m_albumUrl;     // Current album Url use in the thread.
    KURL::List          m_albumUrlList; // Urls of Albums list from setup dialog.

    TQColor              m_backgroundColor;
    TQColor              m_bordersImagesColor;
    TQColor              m_foregroundColor;

    TQObject            *m_parent;

    TQString             m_AlbumCollection;
    TQString             m_AlbumComments;
    TQString             m_AlbumDate;
    TQString             m_AlbumTitle;
    TQString             m_HTMLInterfaceAutoRunFolder;
    TQString             m_HTMLInterfaceAutoRunInf;
    TQString             m_HTMLInterfaceFolder;
    TQString             m_HTMLInterfaceIndex;
    TQString             m_K3bBinPathName;
    TQString             m_K3bParameters;
    TQString             m_StreamMainPageAlbumPreview;
    TQString             m_applicationID;
    TQString             m_bordersImagesSize;
    TQString             m_fontName;
    TQString             m_fontSize;
    TQString             m_hostName;
    TQString             m_hostURL;
    TQString             m_imageFormat;
    TQString             m_imagesFileFilter;
    TQString             m_mainTitle;
    TQString             m_mediaFormat;
    TQString             m_preparer;
    TQString             m_publisher;
    TQString             m_systemID;
    TQString             m_tmpFolder;
    TQString             m_volumeID;
    TQString             m_volumeSetID;

    TQStringList        m_collection_name_list;

    TQValueList<KIPI::ImageCollection> m_albumsList;

    bool                m_cancelled;
    bool                m_copyFiles;
    bool                m_useAutoRunWin32;
    bool                m_useCheckCD;
    bool                m_useHTMLInterface;
    bool                m_useOnTheFly;
    bool                m_useStartBurningProcess;

    int                 m_albumListSize;
    int                 m_imagesPerRow;
    int                 m_imgHeight;
    int                 m_imgWidth;
    int                 m_targetImgHeight;
    int                 m_targetImgWidth;
    int                 m_thumbnailsSize;

    pid_t               m_k3bPid;

private:

    bool buildHTMLInterface (void);

    bool createDirectory(TQDir thumb_dir, TQString imgGalleryDir, TQString dirName);

    void createHead(TQTextStream& stream);
    void createCSSSection(TQTextStream& stream);

    void createBody(TQTextStream& stream,
                    const KIPI::ImageCollection& album,
                    const KURL& targetURL,
                    const TQString& imageFormat);

    int  createThumb( const TQString& imgName, const TQString& sourceDirName, const TQString& uniqueFileName,
                      const TQString& imgGalleryDir, const TQString& imageFormat);

    int  ResizeImage( const TQString Path, const TQString Directory, const TQString ImageFormat,
                      const TQString ImageNameFormat, int *Width, int *Height, int SizeFactor,
                      bool ColorDepthChange, int ColorDepthValue, bool CompressionSet, int ImageCompression);

    bool createHtml( const KIPI::ImageCollection& album,
                     const KURL& targetURL,
                     const TQString& imageFormat );

    bool createPage(const TQString& imgGalleryDir,
                    const KURL& imgURL,
                    const TQString& uniqueImgName,
                    const KURL& prevImgURL,
                    const TQString& prevUniqueImgName,
                    const KURL& nextImgURL,
                    const TQString& nextUniqueImgName,
                    const TQString& comment);

    void createBodyMainPage(TQTextStream& stream, KURL& url);

    static TQString extension(const TQString& imageFormat);

    bool BuildK3bXMLprojectfile (TQString HTMLinterfaceFolder, TQString IndexHtm,
                                 TQString AutoRunInf, TQString AutorunFolder);

    bool AddFolderTreeToK3bXMLProjectFile (TQString dirname, TQTextStream* stream);
    bool addCollectionToK3bXMLProjectFile(const KIPI::ImageCollection& collection, TQTextStream* stream);
    bool CreateAutoRunInfFile(void);
    bool DeleteDir(TQString dirname);
    bool deldir(TQString dirname);

    TQString EscapeSgmlText(const TQTextCodec* codec, const TQString& strIn,
                           const bool quot = false, const bool apos = false );

    void writeSettings(void);
    void readSettings(void);

    TQString webifyFileName(TQString fileName);
    TQString makeFileNameUnique(TQStringList& list, TQString fileName);

};

}  // NameSpace KIPICDArchivingPlugin

#endif // CDARCHIVING_H
