/* This file is part of the kile project
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2001 Anders Lund <anders.lund@lund.tdcadsl.dk>
   Copyright (C) 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.

   Original from tdebase / kate
*/

#ifndef __KILE_GREP_DIALOG_H_
#define __KILE_GREP_DIALOG_H_

#include <kdialogbase.h>
#include <tqstringlist.h>

#include "kileinfo.h"
#include "latexcmd.h"

class TQCheckBox;
class TQPushButton;
class TQLabel;
class TQEvent;

class KComboBox;
class KLineEdit;
class TDEProcess;
class KURLRequester;
class TDEListBox;

#define KILEGREP_MAX 12

namespace KileGrep
{
	enum Mode { Project=0, Directory  };
	enum List { SearchItems=0, SearchPaths, SearchTemplates };
	enum TemplateMode { tmNormal=0,tmCommand,tmCommandWithOption,tmEnv,tmGraphics,tmLabel,tmRefs,tmFiles };
}

class KileGrepDialog : public KDialogBase
{
	TQ_OBJECT
  

public:
	KileGrepDialog(TQWidget *parent, KileInfo *ki, KileGrep::Mode mode, const char *name = 0);
	~KileGrepDialog();

	void appendFilter(const TQString &name, const TQString &filter);

	void appendTemplate(const TQString &name, const TQString &regexp);
	void clearTemplates();

public slots:
	void slotSearchFor(const TQString &pattern);

signals:
	void itemSelected(const TQString &abs_filename, int line);

private:
	KileInfo *m_ki;
	KileGrep::Mode m_mode;
	TDEProcess *childproc;
	int m_grepJobs;

	void readConfig();
	void writeConfig();

	TQStringList getListItems(KComboBox *combo);
	int findListItem(KComboBox *combo, const TQString &s);
	void updateListItems(KComboBox *combo);

	void processOutput();
	void finish();

	void startGrep();
	bool shouldRestart() { return (m_grepJobs > 0); }
	void clearGrepJobs() { m_grepJobs = 0; }
	TQString buildFilesCommand();
	TQString buildProjectCommand();
	TQString getPattern();
	TQString getShellPattern();
	TQString getCommandList(KileDocument::CmdAttribute attrtype);

	void setupDirectory();
	void setupProject();
	void setDirName(const TQString &dir);
	void setFilter(const TQString &filter);
	TQStringList readList(KileGrep::List listtype);
	void updateLists();
	void updateWidgets();

	TQStringList m_projectfiles;
	TQString m_projectdir;
	bool m_projectOpened;
	
	TQLabel *projectname_label, *projectdirname_label;
	KLineEdit *template_edit;
	KComboBox *filter_combo, *pattern_combo, *template_combo;
	KURLRequester *dir_combo;
	TQCheckBox *recursive_box;
	TDEListBox *resultbox;
	TQPushButton *search_button, *clear_button, *close_button;
	TQString buf;
	TQString errbuf;
	TQStringList lastSearchPaths;
	TQStringList filter_list;
	TQStringList template_list;
	int m_lastTemplateIndex;

private slots:
	void childExited();
	void receivedOutput(TDEProcess *proc, char *buffer, int buflen);
	void receivedErrOutput(TDEProcess *proc, char *buffer, int buflen);
	void slotItemSelected(const TQString&);
	void slotSearch();
	void slotClear();
	void slotClose();
	void slotFinished();
	void slotPatternTextChanged(const TQString &);
	void slotTemplateActivated(int index);
};

#endif // __KILE_GREP_DIALOG_H_
