/***************************************************************************
                          zplutils.h  -  description
                             -------------------
    begin                : Son Okt 12 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZPLUTILS_H
#define ZPLUTILS_H

#include <tqpaintdevice.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>

class TQColor;
class TQFont;
class TQImage;
class TQSize;
class TQTextStream;

class BarcodePrinterDevice : public TQPaintDevice {
    public:
        BarcodePrinterDevice( double dpix, double dpiy );
        
        bool isExtDev() const { return true; }
        bool paintingActive() const { return false; }

        virtual int metric( int e ) const;
        
    private: 
        double m_resolution_x;
        double m_resolution_y;
};

/**
  * This class provides functions
  * to convert KBarcode label data
  * into Zebra Printer Language.
  *
  *@author Dominik Seichter
  */
class ZPLUtils {
    public: 
        static TQString footer();
        static TQString header();
        
        static TQString encoding( const TQString & encoding );
        static TQString fieldData( const TQString & data );
        static TQString fieldOrigin( int x, int y );
        static TQString font( const TQFont & font );

    private:
        static void fillEncodings();
        
    protected:
        static TQMap<TQString,TQString> encodings;
};

/**
  * This class provides functions
  * to convert KBarcode label data
  * into Intermec printer language.
  *
  * Thanks to Erich Kitzmller for providing
  * me with information and an examplefor this stuff.
  *@author Dominik Seichter
  */
class IPLUtils {
    public:
        IPLUtils();
        
        void addValue( const TQString & v );
        int counter();
        
        TQString encoding( const TQString & type );
        TQString footer();
        TQString header();

        TQString field( const TQString & data );
        TQString fieldOrigin( int x, int y );
    
    private:
        int m_counter;
        TQStringList m_values;
        static TQMap<TQString,TQString> encodings;
                
        /** fill the map to match kbarcode encoding types with IPL types */
        void fillEncodings();
};

/**
  * This class provides functions
  * to convert KBarcode label data
  * into Eltron printer control language (EPCL).
  *
  *@author Brian Glass
  */
#define EPCLWidth 646
#define EPCLHeight 1030

class EPCLUtils {
    public:
        static TQString encoding( const TQString & type );
        static TQString footer();
        static TQString header();

        static TQString field( const TQString & data );
        
        
        EPCLUtils( TQTextStream* stream, TQPaintDevice* source );

        void setTextField( int x, int y, int width, int height, const TQString & text );
        void setBarcode( int x, int y, int h, const TQString & value, const TQString & type );
        void setRect( int x, int y, const TQSize size, bool circle, int width );        
        void setImage( int x, int y, const TQImage* image );
        void close();
                
    private:
        static void fillEncodings();
        static TQMap<TQString,TQString> encodings;
        
        inline void setField( const TQString & data );
        void fillImageBuffer( void );
};

#endif
