/***************************************************************************
                         imageitem.h  -  description
                             -------------------
    begin                : Do Sep 9 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/
#ifndef IMAGEITEM_H
#define IMAGEITEM_H

#include "documentitem.h"

#include <tqpixmap.h>

enum EImageScaling { eImage_Original = 0, eImage_Scaled, eImage_Zoomed };

/**
@author Dominik Seichter
*/
class ImageItem : public DocumentItem
{
 public:
    ImageItem();
    ~ImageItem();

    void setExpression( const TQString & ex );
    inline TQString expression() const { return m_expression; };

    void setPixmap( const TQPixmap & pix );
    const TQPixmap & pixmap();
    
    void setScaling( EImageScaling scaling );
    EImageScaling scaling() const;
    
    void setRotation( double rot );
    double rotation() const;

    void setMirrorHorizontal( bool b );
    bool mirrorHorizontal() const;
    
    void setMirrorVertical( bool b );
    bool mirrorVertical() const;
    
    virtual int rtti() const { return eRtti_Image;}
    virtual void draw(TQPainter* painter);
    virtual void drawZpl( TQTextStream* stream );
    virtual void drawIpl( TQTextStream* stream, IPLUtils* utils );
    virtual void drawEPcl( TQTextStream* stream );
    virtual void loadXML(TQDomElement* element);
    virtual void saveXML(TQDomElement* element);
 
    void updateImage();
    void createImage();
    
 private:
    void init();
    
 private:
    TQString m_expression;
    TQPixmap m_pixmap;
    TQPixmap m_tmp;
    
    double m_rotation;
    bool m_mirror_v;
    bool m_mirror_h;
       
    EImageScaling m_scaling;
};

#endif
