/*
 * dvbpanel.h
 *
 * Copyright (C) 2004-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBPANEL_H
#define DVBPANEL_H

#include <tqframe.h>
#include <tqcombobox.h>
#include <tqtoolbutton.h>
#include <tqptrlist.h>
#include <tqtimer.h>
#include <tqsplitter.h>
#include <tqvbox.h>

#include <kpushbutton.h>
#include <kled.h>
#include <tdelistview.h>
#include <kiconview.h>
#include <klineedit.h>

#include "scandialog.h"
#include "dvbconfig.h"
#include "krecord.h"
#include "ts2rtp.h"
#include "cleaner.h"
#include "dvbevents.h"
#include "kaffeineinput.h"



class ChannelDesc;
class DvbStream;
class DvbPanel;
class KaffeineDvbPlugin;



class DListView : public TDEListView
{
	TQ_OBJECT
  
public:
	DListView( TQWidget *parent );

	int visibleItems;

protected:
	virtual TQDragObject* dragObject();
};



class DIconViewItem : public TDEIconViewItem
{
public:
	DIconViewItem( DvbPanel *pan, TQIconView *parent, const TQString &text, const TQPixmap &icon );
protected:
	void dropped( TQDropEvent *e, const TQValueList<TQIconDragItem> & );
private:
	DvbPanel *panel;
};



class DvbPanel : public KaffeineInput
{
	TQ_OBJECT
  

public:

	DvbPanel( TQWidget *parent, TQObject *objParent, const char *name=0);
	~DvbPanel();
	bool getChannelList();
	bool saveChannelList();
	bool timeShiftMode();
	void setConfig();
	void enableLiveDvb( bool on );
	void checkFirstRun();
	void moveChannel( const TQString &cat, const TQString &name );

	// Reimplemented from KaffeineInput
	TQWidget *wantPlayerWindow();
	TQWidget *inputMainWidget();
	void toggleLayout( bool );
	bool close();
	bool nextTrack( MRL& );
	bool previousTrack( MRL& );
	bool currentTrack( MRL& );
	bool trackNumber( int, MRL& );
	bool playbackFinished( MRL& );
	void getTargets( TQStringList &uiNames, TQStringList &iconNames, TQStringList &targetNames );
	void togglePanel();
	bool execTarget( const TQString& );
	void saveConfig();
	//***************************************

	TQPtrList<ChannelDesc> channels;
	TQPtrList<RecTimer> timers;
	TQPtrList<DvbStream> dvb;
	TQString fifoName, fifoName1, currentFifo;
	TQString timeShiftFileName;
	Ts2Rtp *rtp;
	TQVBox *mainWidget;
	TQVBox *playerBox, *pbox;

public slots:

	void playLastChannel();
	void playNumChannel( int num );
	void stopLive();
	void setShiftLed( bool on );
	void setRecordLed( bool on );
	void setBroadcastLed( bool on );
	void setRecord();
	void setBroadcast();
	void pauseLiveTV();
	void killTimer( RecTimer *t );
	void showEvents();
	void showTimers();
	void scanner();
	void showConfigDialog();
	void next();
	void previous();
	void recallZap();
	void dvbOSD();

	void dvbOSDNext();
	void dvbOSDPrev();
	void dvbOSDSkip(int skip, int timeShift = 0);
	void dvbOSDZap();
	void dvbOSDHide();

	void dvbOSDAdvance();
	void dvbOSDRetreat();

	void dvbNewTimer( TQString name, TQString channel, TQString datetime, TQString duration );
	int getSNR( int device );
	void diskStatus();
	void camClicked( int devNum );

private:

	void setupActions();
	bool getTimerList();
	bool saveTimerList();
	void fillChannelList( ChannelDesc *ch=0 );
	TQPtrList<Transponder> getSourcesStatus();
	void updateModeTimer( RecTimer *t );
	DvbStream* getWorkingDvb( int mode, ChannelDesc *chan );

	void dvbOSD(ChannelDesc liveChannel, DvbStream *d, int timeShift = 0);
	DvbStream* getLiveDVBStream();

	TQPixmap tvPix, raPix, tvcPix, racPix;
	TQSplitter *split;
	TQFrame *panel;
	TDEIconView *iconView;
	DListView *channelsCb;
	TQToolButton *broadcastBtn, *recordBtn;
	TQToolButton *dateBtn, *infoBtn, *channelsBtn, *configBtn, *osdBtn, *recallBtn;
	KLed *shiftLed, *recordLed, *broadcastLed;
	TQTimer timersTimer;
	DVBconfig *dvbConfig;
	KRecord *timersDialog;
	int updown;
	unsigned long autocount;
	int currentChannelNumber;
	Cleaner *cleaner;
	int osdMode;
	TQTimer osdTimer;
	TQTimer showOsdTimer;
	TQString currentCategory;
	bool isTuning;
	TQTimer tuningTimer, stopTuningTimer;
	TQTimer diskTimer;
	KLineEdit *searchLE;
	TQToolButton *searchBtn;
	int recallChannel;

	int browseDvbStream;
	int maxChannelNumber, minChannelNumber;
	int browseDvbTimeShift;

	KaffeineDvbPlugin *plug;
	TQString plugName;

	EventTable events;

private slots:

	void searchChannel( const TQString &text );
	void resetSearch();
	void checkTimers();
	bool editChannel( TQString &name );
	void channelSelected( TQListViewItem *it );
	void channelClicked( TQListViewItem *it );
	void channelSelected( const TQString &name );
	void channelPopup( TQListViewItem *it, const TQPoint &pos, int col );
	void dvbZap( ChannelDesc *chan );
	void finalZap( DvbStream *d, ChannelDesc *chan );
	void newTimer( TQString channel, TQString name, TQDateTime begin, TQTime duration, bool warn=true );
	void dumpEvents();
	void resetOSD();
	void catContextMenu( TQIconViewItem*, const TQPoint& );
	void catSelected( TQIconViewItem* );
	void channelNumberChanged( TQListViewItem* );
	void pipeOpened();
	void setTuning();

signals:

	void zap( ChannelDesc* );
	void playDvb();
	void timersChanged();
	void dvbOpen( const TQString &filename, const TQString &chanName, int haveVideo );
	void dvbStop();
	void dvbPause( bool pauseLive );
	void setTimeShiftFilename( const TQString& );
	void showOSD( const TQString &text, int duration, int priority );
	void showDvbOSD( const TQStringList& );
	void showDvbOSD( const TQString&, const TQStringList& );

	void updateTimer(RecTimer*, int);
};

#endif /* DVBPANEL_H */
