###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### libdvdread

pkg_search_module ( LIBDVDREAD dvdread REQUIRED )
if ( NOT LIBDVDREAD_FOUND )
  tde_message_fatal( "libdvdread is required, but was not found on your system" )
endif ( )


##### ffmpeg

pkg_search_module( LIBAVCODEC libavcodec )
if( NOT LIBAVCODEC_FOUND )
  tde_message_fatal( "libavcodec is required, but was not found on your system" )
endif( )

pkg_search_module( LIBAVFORMAT libavformat )
if( NOT LIBAVFORMAT_FOUND )
  tde_message_fatal( "libavformat is required, but was not found on your system" )
endif( )

pkg_search_module( LIBAVUTIL libavutil )
if( NOT LIBAVUTIL_FOUND )
  tde_message_fatal( "libavutil is required, but was not found on your system" )
endif( )

pkg_search_module( LIBSWSCALE libswscale )
if( NOT LIBSWSCALE_FOUND )
  tde_message_fatal( "libswscale is required, but was not found on your system" )
endif( )

##### k3bdevice library
find_library( HAVE_K3BDEVICE k3bdevice )
if( HAVE_K3BDEVICE )
  set( K3BDEVICE_LIBRARY "k3bdevice" )
else()
  tde_message_fatal( "libk3bdevice is required, but was not found on your system" )
endif( )


##### OpenGL

if( WITH_OPENGL )
  set( OpenGL_GL_PREFERENCE LEGACY )
  find_package( OpenGL )
  if( NOT OPENGL_FOUND )
    tde_message_fatal( "OpenGL is required, but was not found on your system" )
  endif( NOT OPENGL_FOUND )
  set( HAVE_OPENGL ${OPENGL_FOUND} )
endif( WITH_OPENGL )


##### types

check_include_file( "inttypes.h" HAVE_INTTYPES_H )
check_include_file( "stdint.h" HAVE_STDINT_H )


##### architecture

if( ${CMAKE_SYSTEM_PROCESSOR} STREQUAL "i386" OR ${CMAKE_SYSTEM_PROCESSOR} STREQUAL "i686" )
  set( ARCH_X86 1 )
elseif( ${CMAKE_SYSTEM_PROCESSOR} STREQUAL "x86_64" )
  set( ARCH_X86_64 1 )
elseif( ${CMAKE_SYSTEM_PROCESSOR} STREQUAL "alpha" )
  set( ARCH_ALPHA 1 )
elseif( ${CMAKE_SYSTEM_PROCESSOR} MATCHES ppc* )
  set( ARCH_PPC 1 )
elseif( ${CMAKE_SYSTEM_PROCESSOR} MATCHES sparc* )
  set( ARCH_SPARC 1 )
endif()


### check for strlcat
check_symbol_exists( strlcat string.h HAVE_STRLCAT_PROTO )
