/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-06-14
 * Description : DImg image loader interface
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2005-2009 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef DIMGLOADER_H
#define DIMGLOADER_H

// TQt includes.

#include <tqmap.h>
#include <tqstring.h>
#include <tqcstring.h>
#include <tqvariant.h>

// Local includes.

#include "dimg.h"
#include "digikam_export.h"

namespace Digikam
{

class DImgLoaderObserver;

class DIGIKAM_EXPORT DImgLoader
{
public:

    virtual ~DImgLoader() {};

    virtual bool load(const TQString& filePath, DImgLoaderObserver *observer) = 0;
    virtual bool save(const TQString& filePath, DImgLoaderObserver *observer) = 0;

    virtual bool hasAlpha()   const = 0;
    virtual bool sixteenBit() const = 0;
    virtual bool isReadOnly() const = 0;

protected:

    DImgLoader(DImg* image);

    unsigned char*&         imageData();
    unsigned int&           imageWidth();
    unsigned int&           imageHeight();

    bool                    imageHasAlpha();
    bool                    imageSixteenBit();

    int                     imageBitsDepth();
    int                     imageBytesDepth();

    TQMap<int, TQByteArray>&  imageMetaData();
    TQVariant                imageGetAttribute(const TQString& key);
    void                    imageSetAttribute(const TQString& key, const TQVariant& value);

    TQMap<TQString, TQString>& imageEmbeddedText();    
    TQString                 imageGetEmbbededText(const TQString& key);
    void                    imageSetEmbbededText(const TQString& key, const TQString& text);

    virtual bool            readMetadata(const TQString& filePath, DImg::FORMAT ff);
    virtual bool            saveMetadata(const TQString& filePath);
    virtual int             granularity(DImgLoaderObserver *observer, int total, float progressSlice = 1.0);

    bool                    checkExifWorkingColorSpace();

protected:

    DImg                   *m_image;

private:

    DImgLoader();
};

}  // NameSpace Digikam

#endif /* DIMGLOADER_H */
