/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-01-20
 * Description : a digiKam image plugin to add a border
 *               around an image.
 * 
 * Copyright 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright 2006-2008 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef IMAGEEFFECT_BORDER_H
#define IMAGEEFFECT_BORDER_H

// TQt includes.

#include <tqstring.h>

// Digikam includes.

#include "imageguidedlg.h"

class TQComboBox;
class TQLabel;
class TQCheckBox;
class TQColor;

class KIntNumInput;
class KColorButton;

namespace DigikamBorderImagesPlugin
{

class ImageEffect_Border : public Digikam::ImageGuideDlg
{
    TQ_OBJECT
  
    
public:

    ImageEffect_Border(TQWidget *parent);
    ~ImageEffect_Border();

private:

    TQString getBorderPath(int border);
    
private slots:

    void slotPreserveAspectRatioToggled(bool);
    void slotBorderTypeChanged(int borderType);
    void slotColorForegroundChanged(const TQColor &color);
    void slotColorBackgroundChanged(const TQColor &color);
    void readUserSettings();

private:

    void writeUserSettings();
    void resetValues();  
    void prepareEffect();
    void prepareFinal();
    void putPreviewData();
    void putFinalData();
    void renderingFinished();
    void toggleBorderSlider(bool b);

private:

    TQLabel       *m_labelBorderPercent;
    TQLabel       *m_labelBorderWidth;
    TQLabel       *m_labelForeground;
    TQLabel       *m_labelBackground;

    TQComboBox    *m_borderType;

    TQCheckBox    *m_preserveAspectRatio;
    
    TQColor        m_solidColor;
    TQColor        m_niepceBorderColor;
    TQColor        m_niepceLineColor;
    TQColor        m_bevelUpperLeftColor; 
    TQColor        m_bevelLowerRightColor;
    TQColor        m_decorativeFirstColor; 
    TQColor        m_decorativeSecondColor;
    
    KIntNumInput *m_borderPercent;
    KIntNumInput *m_borderWidth;
    
    KColorButton *m_firstColorButton;
    KColorButton *m_secondColorButton;    
};

}  // NameSpace DigikamBorderImagesPlugin

#endif /* IMAGEEFFECT_BORDER_H */
