/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2008-01-14
 * Description : Searches dates folder view used by timeline
 *
 * Copyright (C) 2008-2009 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2009 by Andi Clemens <andi dot clemens at gmx dot net>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef TIMELINEFOLDERVIEW_H
#define TIMELINEFOLDERVIEW_H

// Local includes.

#include "folderview.h"

namespace Digikam
{

class SAlbum;
class TimeLineFolderItem;

class TimeLineFolderView : public FolderView
{
    TQ_OBJECT

public:

    TimeLineFolderView(TQWidget* parent);
    ~TimeLineFolderView();

    void searchDelete(SAlbum* album);
    TQString currentTimeLineSearchName() const;

signals:

    void signalTextSearchFilterMatch(bool);
    void signalAlbumSelected(SAlbum*);
    void signalRenameAlbum(SAlbum*);

public slots:

    void slotTextSearchFilterChanged(const TQString&);

private slots:

    void slotAlbumAdded(Album* album);
    void slotAlbumDeleted(Album* album);
    void slotAlbumRenamed(Album* album);
    void slotSelectionChanged();
    void slotContextMenu(TQListViewItem*, const TQPoint&, int);

protected:

    void selectItem(int id);

private:

    // Used to store in database the name of search performed by
    // current selection from timeline.
    TQString m_currentTimeLineSearchName;
};

}  // namespace Digikam

#endif /* TIMELINEFOLDERVIEW_H */
